<?php (defined('BASEPATH')) OR exit('No direct script access allowed'); ?>

<div class="modal-dialog">
    <div class="modal-content">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-hidden="true"><i class="fa fa-times"></i></button>
            <h4 class="modal-title" id="myModalLabel"><?php echo lang('edit_delivery'); ?></h4>
        </div>
        <?= form_open_multipart("sales/edit_delivery/".$sales->id); ?>
        <div class="modal-body">
            <div class="row">
                <div class="col-sm-6" style="display:none;">
                    <?= lang('sale_no_ref', 'id'); ?>
                    <?= form_input('id', $sales->id, 'class="form-control tip" id="id"  Readonly'); ?>
                </div>
                <div class="col-sm-6">
                    <?= lang('sale_no_ref', 'inv_number'); ?>
                    <?= form_input('inv_number', $sales->inv_number, 'class="form-control tip" id="inv_number"  Readonly'); ?>
                </div>
                <div class="col-sm-6">
                    <?= lang('date', 'date'); ?>
                    <?= form_input('date', $sales->date, 'class="form-control tip" id="date"  Readonly'); ?>
                </div>
                <div class="col-sm-6">
                    <?= lang('customer', 'customer_name'); ?>
                    <?= form_input('customer_name', $sales->customer_name, 'class="form-control tip" id="customer_name"  Readonly'); ?>
                </div>
                <div class="col-sm-6">
                    <?= lang('grand_total', 'grand_total'); ?>
                    <?= form_input('grand_total', $this->tec->formatMoney($sales->grand_total), 'class="form-control tip" id="grand_total"  Readonly'); ?>
                </div>
                <div class="clearfix"></div>
                <div class="col-sm-6">
                    <?= lang("delivery_by", "delivery_by"); ?>
                    <?= form_input('delivery_by', (isset($_POST['delivery_by']) ? $_POST['delivery_by'] : $sales->delivery_by), 'class="form-control tip" id="delivery_by"'); ?>
                </div>
                <div class="col-sm-6">
                    <?= lang('delivery_status', 'delivery_status'); ?>
                    <?php $opts = array('packing' => lang('packing'), 'delivering' => lang('delivering'), 'delivered' => lang('delivered')); ?>
                    <?= form_dropdown('delivery_status', $opts, $sales->delivery_status, 'class="form-control tip select2" id="delivery_status"  style="width:100%;"'); ?>
                </div>
                <div class="col-sm-6">
                    <?= lang("delivery_staff", "delivery_staff"); ?>
                    <?= form_input('delivery_staff', (isset($_POST['delivery_staff']) ? $_POST['delivery_staff'] : $sales->delivery_staff), 'class="form-control tip" id="delivery_staff"'); ?>
                </div>
                <div class="col-sm-6">
                    <?= lang("delivery_date", "delivery_date"); ?>
                    <?= form_input('delivery_date', (isset($_POST['delivery_date']) ? $_POST['delivery_date'] : $sales->delivery_date), 'class="form-control datetimepicker" id="delivery_date" required="required"'); ?>
                </div>
        </div>
        <div>
                <div class="form-group">
                    <?= lang("delivery_note", "delivery_note"); ?>
                    <?= form_input('delivery_note', (isset($_POST['delivery_note']) ? $_POST['delivery_note'] : $sales->delivery_note), 'class="form-control tip" id="delivery_note"'); ?>
                </div>
                <div class="form-group">
                    <?= lang('attachment', 'attachment'); ?>
                    <input type="file" name="userfile" class="form-control tip" id="attachment">
                </div>
        </div>    
        <div class="modal-footer">
            <?php echo form_submit('edit_delivery', lang('edit_delivery'), 'class="btn btn-primary"'); ?>
        </div>
    </div>
    <?php echo form_close(); ?>
</div>

<script src="<?= $assets ?>plugins/bootstrap-datetimepicker/js/moment.min.js" type="text/javascript"></script>
<script src="<?= $assets ?>plugins/bootstrap-datetimepicker/js/bootstrap-datetimepicker.min.js" type="text/javascript"></script>
<script type="text/javascript">
    $(function () {
        $('.datetimepicker').datetimepicker({
            format: 'YYYY-MM-DD'
        });
    });
</script>
