<?php (defined('BASEPATH')) OR exit('No direct script access allowed'); ?>

<section class="content">
    <div class="row">
        <div class="col-xs-12">
            <div class="box box-primary">
                <div class="box-header">
                    <h3 class="box-title"><?= lang('enter_info'); ?></h3>
                </div>
                <div class="box-body">
                    <div class="col-lg-12">
                        <?= form_open_multipart("products/update_price", 'class="validation"');?>
                        <div class="row">
                            <div class="col-md-6">                                                               
                                <div class="form-group">
                                    <?= lang('category', 'category'); ?>
                                    <?php
                                    $cat['0'] = lang("all");
                                    foreach($categories as $category) {
                                        $cat[$category->id] = $category->name;
                                    }
                                    ?>
                                    <?= form_dropdown('category', $cat, set_value('category'), 'class="form-control select2 tip" id="category"  required="required" style="width:100%;"'); ?>
                                </div>
                                <div class="form-group">
                                    <?= lang('type', 'type'); ?>
                                    <?php $opts = array('increase' => lang('increase'), 'decrease' => lang('decrease'), 'assign' => lang('assign')); ?>
                                    <?= form_dropdown('type', $opts, set_value('type', 'increase'), 'class="form-control tip select2" id="type"  required="required" style="width:100%;"'); ?>
                                </div>                                
                                <div class="form-group udt">
                                    <?= lang('from', 'from'); ?>
                                    <?php $opts = array('price' => lang('price'), 'cost' => lang('cost')); ?>
                                    <?= form_dropdown('from', $opts, set_value('from', 'price'), 'class="form-control tip select2" id="from"  required="required" style="width:100%;"'); ?>
                                </div>
                                <div class="form-group udt">
                                    <?= lang('percentage', 'percentage'); ?>
                                    <?= form_input('percentage', set_value('percentage'), 'class="form-control tip" id="percentage"'); ?>
                                </div>
                                
                                <div class="form-group ass">
                                    <?= lang('price', 'price'); ?>
                                    <?= form_input('price', set_value('price'), 'class="form-control tip" id="price"'); ?>
                                </div>
                                <? if ($Settings->show_wholesale) { ?>
                                <div class="form-group ass">
                                    <?= lang('price_wholesale', 'price_wholesale'); ?>
                                    <?= form_input('price_wholesale', set_value('price_wholesale'), 'class="form-control tip" id="price_wholesale"'); ?>
                                </div>
                                <div class="form-group ass">
                                    <?= lang('price_vip', 'price_vip'); ?>
                                    <?= form_input('price_vip', set_value('price_vip'), 'class="form-control tip" id="price_vip"'); ?>
                                </div>
                                <? } ?>
                                
                                <div class="form-group">
                                    <?= form_submit('update_price', lang('update_price'), 'class="btn btn-primary"'); ?>
                                </div>
                        </div>
                        
                        <?= form_close();?>
                    </div>
                    <div class="clearfix"></div>
                </div>
            </div>
        </div>
    </div>
</section>
<script src="<?= $assets ?>plugins/bootstrap-datetimepicker/js/moment.min.js" type="text/javascript"></script>
<script src="<?= $assets ?>plugins/bootstrap-datetimepicker/js/bootstrap-datetimepicker.min.js" type="text/javascript"></script>
<script type="text/javascript">
    $(function () {
        $('.datetimepicker').datetimepicker({
            format: 'YYYY-MM-DD'
        });
    });
</script>


<script type="text/javascript" charset="utf-8">
    var price = 0; cost = 0; items = {};
    $(document).ready(function() {
        
        
        $('#type').change(function(e) {
            var type = $(this).val();
            if (type == 'assign') {
                $('.ass').slideDown();
                $('.udt').slideUp();
            } else {
                $('.udt').slideDown();
                $('.ass').slideUp();
            }
        });

        $('#type').val('increase').change();

        $("#add_item").autocomplete({
            source: '<?= site_url('products/suggestions'); ?>',
            minLength: 1,
            autoFocus: false,
            delay: 200,
            response: function (event, ui) {
                if ($(this).val().length >= 16 && ui.content[0].id == 0) {
                    bootbox.alert('<?= lang('no_product_found') ?>', function () {
                        $('#add_item').focus();
                    });
                    $(this).val('');
                }
                else if (ui.content.length == 1 && ui.content[0].id != 0) {
                    ui.item = ui.content[0];
                    $(this).data('ui-autocomplete')._trigger('select', 'autocompleteselect', ui);
                    $(this).autocomplete('close');
                    $(this).removeClass('ui-autocomplete-loading');
                }
                else if (ui.content.length == 1 && ui.content[0].id == 0) {
                    bootbox.alert('<?= lang('no_product_found') ?>', function () {
                        $('#add_item').focus();
                    });
                    $(this).val('');

                }
            },
            select: function (event, ui) {
                event.preventDefault();
                if (ui.item.id !== 0) {
                    var row = add_product_item(ui.item);
                    if (row) {
                        $(this).val('');
                    }
                } else {
                    bootbox.alert('<?= lang('no_product_found') ?>');
                }
            }
        });
        $('#add_item').bind('keypress', function (e) {
            if (e.keyCode == 13) {
                e.preventDefault();
                $(this).autocomplete("search");
            }
        });

        $(document).on('click', '.del', function () {
            var id = $(this).attr('id');
            delete items[id];
            $(this).closest('#row_' + id).remove();
        });


        $(document).on('change', '.rqty', function () {
            var item_id = $(this).attr('data-item');
            items[item_id].row.qty = (parseFloat($(this).val())).toFixed(2);
            add_product_item(null, 1);
        });

        $(document).on('change', '.rprice', function () {
            var item_id = $(this).attr('data-item');
            items[item_id].row.price = (parseFloat($(this).val())).toFixed(2);
            add_product_item(null, 1);
        });

        
    });




</script>
