<?php (defined('BASEPATH')) OR exit('No direct script access allowed'); ?>

<section class="content">
    <div class="row">
        <div class="col-xs-12">
            <div class="box box-primary">
                <div class="box-header">
                    <h3 class="box-title"><?= lang('update_info'); ?></h3>
                </div>
                <div class="box-body">
                    <div class="col-lg-12">
                        <?= form_open_multipart("products/edit/".$product->id, 'class="validation"');?>
                        <div class="row">
                            <div class="col-md-6">
                            <div class="form-group">
                                <?= lang('type', 'type'); ?>
                                <?php //$opts = array('standard' => lang('standard'), 'combo' => lang('combo'), 'service' => lang('service'), 'other' => lang('other')); ?>
                                <?php $opts = array('standard' => lang('standard'), 'combo' => lang('combo'), 'service' => lang('service')); ?>
                                <?= form_dropdown('type', $opts, set_value('type', $product->type), 'class="form-control tip select2" id="type"  required="required" style="width:100%;"'); ?>
                            </div>                                
                                <div class="form-group">
                                    <?= lang('code', 'code'); ?> <?= lang('can_use_barcode'); ?>
                                    <?= form_input('code', $product->code, 'class="form-control tip" id="code"  required="required"'); ?>
                                </div>                                
                                <div class="form-group">
                                    <?= lang('name', 'name'); ?>
                                    <?= form_input('name', $product->name, 'class="form-control tip" id="name"  required="required"'); ?>
                                </div>
                                <? if ($Settings->product_second_name) { ?>
                                <div class="form-group">
                                <? } else { ?>
                                <div class="form-group" style="display:none;">
                                <? } ?>
                                    <?= lang('second_name', 'second_name'); ?>
                                    <?= form_input('second_name', $product->second_name, 'class="form-control tip" id="second_name"'); ?>
                                </div>
                                <div class="form-group all" style="display:none;">
                                    <?= lang("barcode_symbology", "barcode_symbology") ?>
                                    <?php
                                    $bs = array('code25' => 'Code25', 'code39' => 'Code39', 'code128' => 'Code128', 'ean8' => 'EAN8', 'ean13' => 'EAN13', 'upca' => 'UPC-A', 'upce' => 'UPC-E');
                                    echo form_dropdown('barcode_symbology', $bs, set_value('barcode_symbology', $product->barcode_symbology), 'class="form-control select2" id="barcode_symbology" required="required" style="width:100%;"');
                                    ?>
                                </div>

                                <div class="form-group">
                                    <?= lang('category', 'category'); ?>
                                    <?php
                                    $cat[''] = lang("select")." ".lang("category");
                                    foreach($categories as $category) {
                                        $cat[$category->id] = $category->name;
                                    }
                                    ?>
                                    <?= form_dropdown('category', $cat, $product->category_id, 'class="form-control select2 tip" id="category"  required="required"'); ?>
                                </div>

                                <? if ($Settings->show_unit) { ?>
                                <div class="form-group">
                                    <?= lang('unit', 'unit'); ?>
                                    <?php
                                    $uni[''] = lang("select")." ".lang("unit");
                                    foreach($units as $unit) {
                                        $uni[$unit->id] = $unit->name;
                                    }
                                    ?>
                                    <?= form_dropdown('unit', $uni, $product->unit_id, 'class="form-control select2 tip" id="unit" required="required"'); ?>
                                </div>
                                <? } ?>

                                <div class="form-group">
                                    <?= lang('cost', 'cost') . ' (' . $Settings->symbol . ')'; ?>
                                    <?= form_input('cost', $product->cost, 'class="form-control tip" id="cost" required="required"'); ?>
                                </div>

                                <? if ($Settings->exchange_rate > 0) { ?> 
                                <div class="form-group" style="display:none;">
                                    <?= lang('cost', 'cost_exc') . ' (' . $Settings->exchange_rate_symbol . ')'; ?>
                                    <?= form_input('cost_exc', 0, 'class="form-control tip" id="cost_exc"'); ?>
                                </div>
                                <? } ?>

                                <? if ($Settings->exchange_rate2 > 0) { ?> 
                                <div class="form-group" style="display:none;">
                                    <?= lang('cost', 'cost_exc2') . ' (' . $Settings->exchange_rate2_symbol . ')'; ?>
                                    <?= form_input('cost_exc2', 0, 'class="form-control tip" id="cost_exc2"'); ?>
                                </div>
                                <? } ?>

                                <div class="form-group">
                                    <? $price = $this->tec->formatDecimal($product->price); ?>
                                    <?= lang('price', 'price') . ' (' . $Settings->symbol . ')'; ?>
                                    <?= form_input('price', $price, 'class="form-control tip" id="price" required="required"'); ?>
                                </div>
                                    
                                <? if ($Settings->exchange_rate > 0) { ?> 
                                <div class="form-group" style="display:none;">
                                    <?= lang('price', 'price_exc') . ' (' . $Settings->exchange_rate_symbol . ')'; ?>
                                    <?= form_input('price_exc', 0, 'class="form-control tip" id="price_exc"'); ?>
                                </div>
                                <? } ?>

                                <? if ($Settings->exchange_rate2 > 0) { ?> 
                                <div class="form-group" style="display:none;">
                                    <?= lang('price', 'price_exc2') . ' (' . $Settings->exchange_rate2_symbol . ')'; ?>
                                    <?= form_input('price_exc2', 0, 'class="form-control tip" id="price_exc2"'); ?>
                                </div>
                                <? } ?>

                                <? if ($Settings->show_wholesale) { ?>       
                                <div class="form-group">
                                <? } else { ?>
                                <div class="form-group" style="display:none;">
                                <? } ?>
                                    <? $price_wholesale = $this->tec->formatDecimal($product->price_wholesale); ?>
                                    <?= lang('price_wholesale', 'price_wholesale'); ?>
                                    <?= form_input('price_wholesale', $price_wholesale, 'class="form-control tip" id="price_wholesale" required="required"'); ?>
                                </div>
                                <? if ($Settings->show_wholesale) { ?>       
                                <div class="form-group">
                                <? } else { ?>
                                <div class="form-group" style="display:none;">
                                <? } ?>
                                    <? $price_vip = $this->tec->formatDecimal($product->price_vip); ?>
                                    <?= lang('price_vip', 'price_vip'); ?>
                                    <?= form_input('price_vip', $price_vip, 'class="form-control tip" id="price_vip" required="required"'); ?>
                                </div>    

                                <div class="form-group">
                                    <?= lang('promotion', 'promotion'); ?>
                                    <?php $tm = array(0 => lang('No'), 1 => lang('Yes')); ?>
                                    <?= form_dropdown('promotion', $tm, set_value('promotion',$product->promotion), 'class="form-control tip select2" id="promotion" style="width:100%;"'); ?>
                                </div>
                                <div class="form-group promo">
                                    <?= lang('promo_price', 'promo_price'); ?>
                                    <?= form_input('promo_price', set_value('promo_price', $product->promo_price), 'class="form-control tip" id="promo_price"'); ?>
                                </div>
                                <div class="form-group promo">
                                    <?= lang("start_date", "start_date"); ?>
                                    <?= form_input('start_date', (isset($_POST['start_date']) ? $_POST['start_date'] : $product->start_date), 'class="form-control datetimepicker" id="start_date"'); ?>
                                </div>
                                <div class="form-group promo">
                                    <?= lang("end_date", "end_date"); ?>
                                    <?= form_input('end_date', (isset($_POST['end_date']) ? $_POST['end_date'] : $product->end_date), 'class="form-control datetimepicker" id="end_date"'); ?>
                                </div>                           

                                <div class="form-group">
                                    <?= lang('product_tax', 'product_tax'); ?>
                                    <?= form_input('product_tax', $product->tax, 'class="form-control tip" id="product_tax" required="required"'); ?>
                                </div>                                
                                <div class="form-group">
                                    <?= lang('tax_method', 'tax_method'); ?>
                                    <?php $tm = array(0 => lang('inclusive'), 1 => lang('exclusive')); ?>
                                    <?= form_dropdown('tax_method', $tm, set_value('tax_method', $product->tax_method), 'class="form-control tip select2" id="tax_method"  required="required" style="width:100%;"'); ?>
                                </div>
                                <? if ($Settings->show_drink_ingredient) { ?>
                                <div class="form-group">
                                    <?= lang('beverage', 'beverage'); ?>
                                    <?php $tm = array(0 => lang('No'), 1 => lang('Yes')); ?>
                                    <?= form_dropdown('beverage', $tm, set_value('beverage', $product->beverage), 'class="form-control tip select2" id="beverage" style="width:100%;"'); ?>
                                </div>
                                <div class="form-group">
                                    <?= lang('ingredient', 'ingredient'); ?>
                                    <?php $tm = array(0 => lang('No'), 1 => lang('Yes')); ?>
                                    <?= form_dropdown('ingredient', $tm, set_value('ingredient', $product->ingredient), 'class="form-control tip select2" id="ingredient" style="width:100%;"'); ?>
                                </div>
                                <? } else { ?>
                                <div class="form-group" style="display:none;">
                                    <?= lang('beverage', 'beverage'); ?>
                                    <?php $tm = array(0 => lang('No'), 1 => lang('Yes')); ?>
                                    <?= form_dropdown('beverage', $tm, set_value('beverage', $product->beverage), 'class="form-control tip select2" id="beverage" style="width:100%;"'); ?>
                                </div>
                                <div class="form-group" style="display:none;">
                                    <?= lang('ingredient', 'ingredient'); ?>
                                    <?php $tm = array(0 => lang('No'), 1 => lang('Yes')); ?>
                                    <?= form_dropdown('ingredient', $tm, set_value('ingredient', $product->ingredient), 'class="form-control tip select2" id="ingredient" style="width:100%;"'); ?>
                                </div>
                                <? } ?>
                                <div class="form-group st">
                                    <?= lang('alert_quantity', 'alert_quantity'); ?>
                                    <?= form_input('alert_quantity', set_value('alert_quantity', $product->alert_quantity), 'class="form-control tip" id="alert_quantity"  required="required"'); ?>
                                </div>

                                <div class="form-group">
                                    <?= lang('image', 'image') . ' (Max Size 1000 x 1000 pixel)'; ?>
                                    <input type="file" name="userfile" id="image">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div id="ct" style="display:none;">
                                    <div class="form-group">
                                        <?= lang("add_product", "add_item"); ?>
                                        <?php echo form_input('add_item', '', 'class="form-control ttip" id="add_item" data-placement="top" data-trigger="focus" data-bv-notEmpty-message="' . lang('please_add_items_below') . '" placeholder="' . $this->lang->line("add_item") . '"'); ?>
                                    </div>
                                    <div class="control-group table-group">
                                        <label class="table-label" for="combo"><?= lang("combo_products"); ?></label>

                                        <div class="controls table-controls">
                                            <table id="prTable"
                                                   class="table items table-striped table-bordered table-condensed table-hover">
                                                <thead>
                                                <tr>
                                                    <th class="col-xs-9"><?= lang("product_name") . " (" . $this->lang->line("product_code") . ")"; ?></th>
                                                    <th class="col-xs-2"><?= lang("quantity"); ?></th>
                                                    <th class=" col-xs-1 text-center"><i class="fa fa-trash-o trash-opacity-50"></i></th>
                                                </tr>
                                                </thead>
                                                <tbody></tbody>
                                                <tfoot></tfoot>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                                <?php if ($Settings->multi_store) { foreach ($stores as $store) { ?>
                                <?php if ($Settings->multistore_quantity) { ?>
                                <?php if ($store->id == 1) { ?>
                                <div class="">
                                    <div class="well well-sm">
                                        <h3><?= $store->name.' ('.$store->code.')'; ?></h3>
                                        <div class="form-group st">
                                            <?php
                                            $quantity = 0;
                                            foreach ($stores_quantities as $sq) {
                                                if ($sq->store_id == $store->id) {
                                                    $quantity = $sq->quantity;
                                                    $price = $sq->price > 0 ? $this->tec->formatDecimal($sq->price) : '';
                                                    $price_wholesale = $sq->price_wholesale > 0 ? $this->tec->formatDecimal($sq->price_wholesale) : '';
                                                    $price_vip = $sq->price_vip > 0 ? $this->tec->formatDecimal($sq->price_vip) : '';
                                                }
                                            }
                                            ?>
                                            <?= lang('quantity', 'quantity'.$store->id); ?>
                                            <?= form_input('quantity'.$store->id, set_value('quantity', $quantity), 'class="form-control tip" id="quantity'.$store->id.'" '); ?>
                                        </div>
                                        <div class="form-group" style="margin-bottom:0;">
                                            <?= lang('price', 'price'.$store->id); ?>
                                            <?= form_input('price'.$store->id, set_value('price'.$store->id, $price), 'class="form-control tip" id="price'.$store->id.'" placeholder="'.lang('optional').'"'); ?>
                                        </div>  
                                    </div>
                                </div>
                                <?php } else { ?>
                                <div class="">
                                    <div class="well well-sm">
                                        <h3><?= $store->name.' ('.$store->code.')'; ?></h3>
                                        <div class="form-group" style="display:none;">                                            
                                            <?= lang('quantity', 'quantity'.$store->id); ?>
                                            <?= form_input('quantity'.$store->id, set_value('quantity', $quantity), 'class="form-control tip" id="quantity'.$store->id.'" '); ?>
                                        </div>
                                        <div class="form-group" style="margin-bottom:0;">
                                            <?= lang('price', 'price'.$store->id); ?>
                                            <?= form_input('price'.$store->id, set_value('price'.$store->id, $price), 'class="form-control tip" id="price'.$store->id.'" placeholder="'.lang('optional').'"'); ?>
                                        </div>  
                                    </div>
                                </div>
                                <?php } } else { ?>
                                <div class="">
                                    <div class="well well-sm">
                                        <h3><?= $store->name.' ('.$store->code.')'; ?></h3>
                                        <div class="form-group st">
                                            <?php
                                            $quantity = 0;
                                            foreach ($stores_quantities as $sq) {
                                                if ($sq->store_id == $store->id) {
                                                    $quantity = $sq->quantity;
                                                    $price = $sq->price > 0 ? $this->tec->formatDecimal($sq->price) : '';
                                                    $price_wholesale = $sq->price_wholesale > 0 ? $this->tec->formatDecimal($sq->price_wholesale) : '';
                                                    $price_vip = $sq->price_vip > 0 ? $this->tec->formatDecimal($sq->price_vip) : '';
                                                }
                                            }
                                            ?>
                                            <?= lang('quantity', 'quantity'.$store->id); ?>
                                            <?= form_input('quantity'.$store->id, set_value('quantity', $quantity), 'class="form-control tip" id="quantity'.$store->id.'" '); ?>
                                        </div>
                                        <div class="form-group" style="margin-bottom:0;">
                                            <?= lang('price', 'price'.$store->id); ?>
                                            <?= form_input('price'.$store->id, set_value('price'.$store->id, $price), 'class="form-control tip" id="price'.$store->id.'" placeholder="'.lang('optional').'"'); ?>
                                        </div>  
                                    </div>
                                </div>
                                <?php } ?>
                                <?php } } else { ?>
                                <div class="st">
                                    <div class="form-group">
                                        <?= lang('quantity', 'quantity'); ?>
                                        <?= form_input('quantity', set_value('quantity', $stores_quantities->quantity), 'class="form-control tip" id="quantity" '); ?>
                                    </div>
                                    <? if ($Settings->divided) { ?>
                                    <div class="form-group">
                                        <?= lang('divided1', 'divided1'); ?>
                                        <?= form_input('divided1', set_value('divided1', $product->divided1), 'class="form-control tip" id="divided1" '); ?>
                                    </div>

                                    <div class="form-group">
                                        <?= lang('divided2', 'divided2'); ?>
                                        <?= form_input('divided2', set_value('divided2', $product->divided2), 'class="form-control tip" id="divided2" '); ?>
                                    </div>
                                    <? } ?>  

                                    <? if ($Settings->show_expiry) { ?>
                                    <div class="form-group">
										<?= lang("expiry_date", "expiry_date"); ?>
                                        <?= form_input('expiry_date', (isset($_POST['expiry_date']) ? $_POST['expiry_date'] : $product->expiry_date), 'class="form-control datetimepicker" id="expiry_date"'); ?>
									</div>									
									<div class="form-group">
                                        <?= lang('alert_expiry', 'alert_expiry'); ?>
                                        <?= form_input('alert_expiry', set_value('alert_expiry', $product->alert_expiry), 'class="form-control tip" id="alert_expiry"'); ?>
                                    </div>
                                    <? } ?>  
                                    <? if ($Settings->show_product_service) { ?>
                                        <div class="form-group">
                                        <?= lang('service_month', 'service_month'); ?>
                                        <?= form_input('service_month', set_value('service_month', $product->service_month), 'class="form-control tip" id="service_month"'); ?>
                                    </div>									
									<div class="form-group">
                                        <?= lang('alert_service', 'alert_service'); ?>
                                        <?= form_input('alert_service', set_value('alert_service', $product->alert_service), 'class="form-control tip" id="alert_service"'); ?>
                                    </div>
                                    <? } ?>                                  
                                </div>
                                <?php } ?>
                            </div>
                        </div>
                        <div class="form-group">
                            <?= lang('details', 'details'); ?>
                            <?= form_textarea('details', $product->details, 'class="form-control tip redactor" id="details"'); ?>
                        </div>
                        <div class="form-group">
                            <?= form_submit('edit_product', lang('edit_product'), 'class="btn btn-primary"'); ?>
                        </div>
                        <?= form_close();?>
                    </div>
                    <div class="clearfix"></div>
                </div>
            </div>
        </div>
    </div>
</section>

<script src="<?= $assets ?>plugins/bootstrap-datetimepicker/js/moment.min.js" type="text/javascript"></script>
<script src="<?= $assets ?>plugins/bootstrap-datetimepicker/js/bootstrap-datetimepicker.min.js" type="text/javascript"></script>
<script type="text/javascript">
    $(function () {
        $('.datetimepicker').datetimepicker({
            format: 'YYYY-MM-DD'
        });
    });
</script>

<script type="text/javascript" charset="utf-8">
    var price = 0; cost = 0; items = {};
    $(document).ready(function() {
        calculatePriceExc();
        calculateCostExc();

        $('#type').change(function(e) {
            var type = $(this).val();
            if (type == 'combo') {
                $('.st').slideUp();
                $('#ct').slideDown();
                //$('#cost').attr('readonly', true);
            } else if (type == 'service') {
                $('.st').slideUp();
                $('#ct').slideUp();
                //$('#cost').attr('readonly', false);
            } else {
                $('#ct').slideUp();
                $('.st').slideDown();
                //$('#cost').attr('readonly', false);
            }
        });

        $("#add_item").autocomplete({
            source: '<?= site_url('products/suggestions'); ?>',
            minLength: 1,
            autoFocus: false,
            delay: 200,
            response: function (event, ui) {
                if ($(this).val().length >= 16 && ui.content[0].id == 0) {
                    bootbox.alert('<?= lang('no_product_found') ?>', function () {
                        $('#add_item').focus();
                    });
                    $(this).val('');
                }
                else if (ui.content.length == 1 && ui.content[0].id != 0) {
                    ui.item = ui.content[0];
                    $(this).data('ui-autocomplete')._trigger('select', 'autocompleteselect', ui);
                    $(this).autocomplete('close');
                    $(this).removeClass('ui-autocomplete-loading');
                }
                else if (ui.content.length == 1 && ui.content[0].id == 0) {
                    bootbox.alert('<?= lang('no_product_found') ?>', function () {
                        $('#add_item').focus();
                    });
                    $(this).val('');

                }
            },
            select: function (event, ui) {
                event.preventDefault();
                if (ui.item.id !== 0) {
                    var row = add_product_item(ui.item);
                    if (row) {
                        $(this).val('');
                    }
                } else {
                    bootbox.alert('<?= lang('no_product_found') ?>');
                }
            }
        });
        $('#add_item').bind('keypress', function (e) {
            if (e.keyCode == 13) {
                e.preventDefault();
                $(this).autocomplete("search");
            }
        });

        $(document).on('click', '.del', function () {
            var id = $(this).attr('id');
            delete items[id];
            $(this).closest('#row_' + id).remove();
        });


        $(document).on('change', '.rqty', function () {
            var item_id = $(this).attr('data-item');
            items[item_id].row.qty = (parseFloat($(this).val())).toFixed(2);
            add_product_item(null, 1);
        });

        $(document).on('change', '.rprice', function () {
            var item_id = $(this).attr('data-item');
            items[item_id].row.price = (parseFloat($(this).val())).toFixed(2);
            add_product_item(null, 1);
        });        

        function add_product_item(item, noitem) {
            if (item == null && noitem == null) {
                return false;
            }
            if (noitem != 1) {
                item_id = item.row.id;
                if (items[item_id]) {
                    items[item_id].row.qty = (parseFloat(items[item_id].row.qty) + 1).toFixed(2);
                } else {
                    items[item_id] = item;
                }
            }
            price = 0;
            cost = 0;

            $("#prTable tbody").empty();
            $.each(items, function () {
                var item = this.row;
                var row_no = item.id;
                var newTr = $('<tr id="row_' + row_no + '" class="item_' + item.id + '"></tr>');
                tr_html = '<td><input name="combo_item_code[]" type="hidden" value="' + item.code + '"><span id="name_' + row_no + '">' + item.name + ' (' + item.code + ')</span></td>';
                tr_html += '<td><input class="form-control text-center rqty" name="combo_item_quantity[]" type="text" value="' + formatQuantity2(item.qty) + '" data-id="' + row_no + '" data-item="' + item.id + '" id="quantity_' + row_no + '" onClick="this.select();"></td>';
                //tr_html += '<td><input class="form-control text-center rprice" name="combo_item_price[]" type="text" value="' + formatDecimal(item.price) + '" data-id="' + row_no + '" data-item="' + item.id + '" id="combo_item_price_' + row_no + '" onClick="this.select();"></td>';
                tr_html += '<td class="text-center"><i class="fa fa-times tip del" id="' + row_no + '" title="Remove" style="cursor:pointer;"></i></td>';
                newTr.html(tr_html);
                newTr.prependTo("#prTable");
                //price += formatDecimal(item.price*item.qty);
                cost += formatDecimal(item.cost*item.qty);
            });
            $('#cost').val(cost);
            return true;
        }
        var type = $('#type').val();
        if (type == 'combo') {
            $('.st').slideUp();
            $('#ct').slideDown();
            //$('#cost').attr('readonly', true);
        } else if (type == 'service') {
            $('.st').slideUp();
            $('#ct').slideUp();
            //$('#cost').attr('readonly', false);
        } else {
            $('#ct').slideUp();
            $('.st').slideDown();
            //$('#cost').attr('readonly', false);
        }
        <?php
        if ($this->input->post('type') == 'combo') {
            $c = sizeof($_POST['combo_item_code']);
            $items = array();
            for ($r = 0; $r <= $c; $r++) {
                if (isset($_POST['combo_item_code'][$r]) && isset($_POST['combo_item_quantity'][$r])) {
                    $items[] = array('id' => $_POST['combo_item_id'][$r], 'row' => array('id' => $_POST['combo_item_id'][$r], 'name' => $_POST['combo_item_name'][$r], 'code' => $_POST['combo_item_code'][$r], 'qty' => $_POST['combo_item_quantity'][$r], 'cost' => $_POST['combo_item_cost'][$r]));
                }
            }
            echo '
            var ci = '.json_encode($items).';
            $.each(ci, function() { add_product_item(this); });
            ';
        } elseif (!empty($items)) {
            echo '
            var ci = '.json_encode($items).';
            $.each(ci, function() { add_product_item(this); });
            ';
        }
        ?>
    });

    function calculatePriceExc() {
        if (Settings.exchange_rate > 0) {
            if (Settings.exchange_rate_multiply == '*'){
                var price_exc = $("#price").val() * Settings.exchange_rate;
                $("#price_exc").val(formatDecimal(price_exc,2));
            } else {
                var price_exc = $("#price").val() / Settings.exchange_rate;
                $("#price_exc").val(formatDecimal(price_exc,2));
            }
        }
        if (Settings.exchange_rate2 > 0) {
            if (Settings.exchange_rate2_multiply == '*'){
                var price_exc2 = $("#price").val() * Settings.exchange_rate2;
                $("#price_exc2").val(formatDecimal(price_exc2,2));
            } else {
                var price_exc2 = $("#price").val() / Settings.exchange_rate2;
                $("#price_exc2").val(formatDecimal(price_exc2,2));
            }
        }
    }

    function calculateCostExc() {
        if (Settings.exchange_rate > 0) {
            if (Settings.exchange_rate_multiply == '*'){
                var cost_exc = $("#cost").val() * Settings.exchange_rate;
                $("#cost_exc").val(formatDecimal(cost_exc,2));
            } else {
                var cost_exc = $("#cost").val() / Settings.exchange_rate;
                $("#cost_exc").val(formatDecimal(cost_exc,2));
            }
        }
        if (Settings.exchange_rate2 > 0) {
            if (Settings.exchange_rate2_multiply == '*'){
                var cost_exc2 = $("#cost").val() * Settings.exchange_rate2;
                $("#cost_exc2").val(formatDecimal(cost_exc2,2));
            } else {
                var cost_exc2 = $("#cost").val() / Settings.exchange_rate2;
                $("#cost_exc2").val(formatDecimal(cost_exc2,2));
            }
        }
    }
    
    $("#price").change(function() {
        calculatePriceExc()        
    });

    $("#cost").change(function() {
        calculateCostExc()        
    });
    
    $("#price_exc").change(function() {
        if (Settings.exchange_rate > 0) {
            if (Settings.exchange_rate_multiply == '*'){
                var price_exc = $(this).val() / Settings.exchange_rate;
                $("#price").val(price_exc);
            } else {
                var price_exc = $(this).val() * Settings.exchange_rate;
                $("#price").val(price_exc);
            }
            calculatePriceExc()
        }        
    });
    
    $("#price_exc2").change(function() {
        if (Settings.exchange_rate2 > 0) {
            if (Settings.exchange_rate2_multiply == '*'){
                var price_exc2 = $(this).val() / Settings.exchange_rate2;
                $("#price").val(price_exc2);
            } else {
                var price_exc2 = $(this).val() * Settings.exchange_rate2;
                $("#price").val(price_exc2);
            }
            calculatePriceExc()
        }        
    });

    $("#cost_exc").change(function() {
        if (Settings.exchange_rate > 0) {
            if (Settings.exchange_rate_multiply == '*'){
                var cost_exc = $(this).val() / Settings.exchange_rate;
                $("#cost").val(cost_exc);
            } else {
                var cost_exc = $(this).val() * Settings.exchange_rate;
                $("#cost").val(cost_exc);
            }
            calculateCostExc()
        }        
    });
    
    $("#cost_exc2").change(function() {
        if (Settings.exchange_rate2 > 0) {
            if (Settings.exchange_rate2_multiply == '*'){
                var cost_exc2 = $(this).val() / Settings.exchange_rate2;
                $("#cost").val(cost_exc2);
            } else {
                var cost_exc2 = $(this).val() * Settings.exchange_rate2;
                $("#cost").val(cost_exc2);
            }
            calculateCostExc()
        }        
    });

    $(function () {
        $('.datetimepicker').datetimepicker({
            format: 'YYYY-MM-DD'
        });
    });

    $('#promotion').change(function(e) {
        if ($(this).val() == 1) {
            $('.promo').show();
        } else {
            $('.promo').hide();
        }
    });
    if ($('#promotion').val() == 1) {
        $('.promo').show();
    } else {
        $('.promo').hide();
    }

</script>
