<?php (defined('BASEPATH')) OR exit('No direct script access allowed'); ?>

<?php
if ($modal) {
    ?>
    <div class="modal-dialog" role="document"<?= $Settings->rtl ? ' dir="rtl"' : ''; ?>>
        <div class="modal-content">
            <div class="modal-body">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"><i class="fa fa-times"></i></button>
                <?php
            } else {
                ?><!doctype html>
                <html<?= $Settings->rtl ? ' dir="rtl"' : ''; ?>>
                <head>
                    <meta charset="utf-8">
                    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
                    <title><?= $page_title . " " . lang("no") . " " . $inv->id; ?></title>
                    <base href="<?= base_url() ?>"/>
                    <meta http-equiv="cache-control" content="max-age=0"/>
                    <meta http-equiv="cache-control" content="no-cache"/>
                    <meta http-equiv="expires" content="0"/>
                    <meta http-equiv="pragma" content="no-cache"/>
                    <link rel="shortcut icon" href="<?= $assets ?>images/icon.png"/>
                    <link rel="preconnect" href="https://fonts.googleapis.com">
                    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
                    <link href="https://fonts.googleapis.com/css2?family=Battambang&display=swap" rel="stylesheet">
                    <script src="<?= $assets ?>dist/js/print.min.js" type="text/javascript"></script>
                    <script src="<?= $assets ?>dist/js/html2canvas.min.js" type="text/javascript"></script>
                    <style type="text/css" media="all">
                        @page {
                            <? echo $Settings->pos_printer_margin ? 'margin: 2px 20px 2px 2px;' : 'margin: 2px 10px;'; ?>
                        }
                        * { -webkit-print-color-adjust: exact !important; /* Chrome, Safari */ color-adjust: exact !important; /*Firefox*/ }
                        body { 
							color: #000; 
							font-family: "Battambang", "Khmer OS Battambang";
							font-size: <?= $Settings->receipt_font_size .'px';?>;
							line-height: 1.42857143;
							margin: 0 5px;
						}
						p {
							margin:5px 0;
						}
						.text-right {
							text-align: right;
                            padding-right: 5px !important;
						}
                        #wrapper { max-width: 480px; margin: 0 auto; padding-top: 20px; }
                        .btn { margin-bottom: 5px; }
                        .table { border-radius: 3px; width:100%; border-collapse: collapse; margin-top:10px; margin-bottom:-10px;}
                        thead.mythead, tr.mythead {color:#000; }
                        tr.mythead, tr.mytotal {color:#fff !important; background-color:#000;}
                        tr.mythead th, tr.mytotal th {color:#fff !important;}
                        tr.mytotal th {font-size: <?= $Settings->receipt_font_size+2 .'px';?>;}
                        tr.mythead th.text-right {padding-right:5px !important;}
						thead.mythead th { padding:10px 0; color:#fff !important;}
						tfoot.mytfoot { border-top: 1px solid #000;}
                        .table th, .table td { vertical-align: middle !important; padding:5px 0; border-top:1px solid;}
                        h3 { margin: 5px 0; }
						a {
							text-decoration: none;
							color: #fff;
						}
						.btn-primary {
							background-color: #3c8dbc;
							border-color: #367fa9;
						}
						.btn-success {
							background-color: #00a65a;
							border-color: #008d4c;
						}
						.btn-warning {
							background-color: #f39c12;
							border-color: #e08e0b;
						}
						.btn-block {
							display: block;
							width: 100%;
						}
						.btn-primary {
							color: #fff;
						}
						.btn {
							border-radius: 3px;
                            font-family: "Battambang", "Khmer OS Battambang";
							margin-bottom: 5px;
							-webkit-box-shadow: none;
							box-shadow: none;
							border: 0px solid transparent;
							display: inline-block;
							padding: 6px 0;
							margin-bottom: 0;
							font-size: 14px;
							font-weight: 400;
							line-height: 1.42857143;
							text-align: center;
							white-space: nowrap;
							-ms-touch-action: manipulation;
							touch-action: manipulation;
							cursor: pointer;
							-webkit-user-select: none;
							-moz-user-select: none;
							-ms-user-select: none;
							user-select: none;
							margin-bottom: 5px;
						}
						.well-sm {
							padding: 5px;
							border-radius: 3px;
						}
						.well {
							min-height: 20px;
							border: 1px solid #000;
							border-radius: 4px;
							-webkit-box-shadow: inset 0 1px 1px rgba(0,0,0,.05);
							box-shadow: inset 0 1px 1px rgba(0,0,0,.05);
						}
						.alert-success {
							background-color: #00a65a!important;
							border-color: #008d4c!important;
						}
						.alert, .callout {
							border-radius: 3px;
						}
						.alert {
							padding: 15px;
							border: 1px solid transparent;
						}
						.alert, .thumbnail {
							margin-bottom: 20px;
						}
						.alert .close {
							color: #000;
							opacity: .2;
							filter: alpha(opacity=20);
						}
						button.close {
							-webkit-appearance: none;
							padding: 0;
							cursor: pointer;
							background: 0 0;
							border: 0;
						}
						.close {
							float: right;
							font-size: 21px;
							line-height: 1;
							color: #000;
							text-shadow: 0 1px 0 #fff;
							filter: alpha(opacity=20);
							opacity: .2;
						}
                        a[href^=tel] {
                            color: inherit;
                            text-decoration: none;
                        }
						.alert .alert-link, .close {
							font-weight: 700;
						}						
                        @media print {
                            .no-print { display: none; }
                            #wrapper { max-width: 700px; min-width: 200px; margin: 0 auto; padding-top:0 !important;}	
                            div#receipt-data {padding-right:0 !important;}					
                        }
                        @media only screen and (max-device-width: 480px) {
                            #wrapper {
                                max-width: 100% !important;
                                margin: 0 auto;
                                padding-top: 10px;
                            }
                            div#receiptData {
                                max-width: 100% !important;
                                margin: 0 auto;
                                padding : 10px;
                            }
                        }
                        <?php if($Settings->rtl) { ?>
                            .text-right { text-align: left; }
                            .text-left { text-align: right; }
                            tfoot tr th:first-child { text-align: left; }
                        <?php } else { ?>
                            tfoot tr th:first-child { text-align: right; }
                        <?php } ?>
                    </style>
                </head>
                <body>
                    <?php
                }
                ?>
                <div id="wrapper">
                    <div id="receiptData" style="width: auto; max-width: 700px; margin: 0 auto;">
                        <div class="no-print">
                            <span class="col-xs-12">
                                <a class="btn btn-block btn-warning" style="padding-top:20px; padding-bottom:20px; font-size:20px;" href="<?= site_url('pos'); ?>"><?= lang("back_to_pos"); ?></a>
                            </span>
                        </div>
                        <div id="receipt-data" style="padding-right:10px;">
                            <div>
                                <div style="text-align:center;">
                                    <?php
                                    if ($store) {
                                        if (!empty($store->logo)) {
										echo '<img src="'.base_url('uploads/'.$store->logo).'" alt="'.$store->name.'">';
										}
                                        echo '<p style="text-align:center; font-size:11px;">'; 
                                        echo '<strong>' . nl2br($store->name) . '</strong><br></p>';                              
                                        echo '<p>'.$store->address1.'<br>'.$store->address2;
                                        echo $store->city.'<br>'.$store->phone;
                                        echo '<br>'.nl2br($store->receipt_header).'</p>';
                                    }                                    
                                    ?>
                                    <?php
                                    if($Settings->show_waiting_number){
                                    echo '<p style="margin:0;">'.lang(waiting_number).':</p>';
                                    echo '<p style="margin:0; font-size:20px; font-weight:bold;">'.$inv->waiting_number.'</p>';
                                    }
                                    ?>
                                </div>
                                <p>  
                                    <?= lang('sale_no_ref').': '.$inv->inv_number; ?><br>
                                    <?= lang("customer").': '. $inv->customer_name; ?> <br>
                                    <?= lang("sales_person").': '. $created_by->first_name." ".$created_by->last_name; ?> <br>
                                    <? if (($Settings->show_date_inout) && ($inv->date_in != '')) { ?>
                                    <?
                                        $hour = (abs(strtotime($inv->date_out) - strtotime($inv->date_in))/3600)%24;
                                        $minute = (abs(strtotime($inv->date_out) - strtotime($inv->date_in))/60)%60;
                                    ?>
                                    <?= lang('date_in').': '.$this->tec->hrld($inv->date_in); ?> <br> 
                                    <?= lang('date_out').': ' .$this->tec->hrld($inv->date_out); ?> <br>
                                    <?= lang('duration').': '. $hour . ' h ' . $minute . ' mn'; ?>
                                    <? } else { ?>
                                    <?= lang("date").': '.$this->tec->hrld($inv->date); ?> <br>
                                    <? } ?>
                                    <? if (($Settings->award_percentage>0) && ($customer->id != 1)) { ?>
                                    <?= lang('award').': <strong>' . $this->tec->formatMoney($customer->award) . '</strong>'; ?>
                                    <? } ?>
                                </p>
                                <div style="clear:both;"></div>
                                <table class="table table-striped table-condensed">
                                    <thead class="mythead">
                                        <tr class="mythead">
                                            <th class="text-center" style="border-bottom: 1px solid;"><?=lang('no');?></th>
                                            <th class="text-center" style="width: 40%; border-bottom: 1px solid;"><?=lang('description');?></th>
                                            <th class="text-center" style="border-bottom: 1px solid;"><?=lang('quantity');?></th>
                                            <? if ($Settings->show_unit) { ?>
                                            <th class="text-center" style="border-bottom: 1px solid;"><?=lang('Unit');?></th>
                                            <? } ?>
                                            <th class="text-center" style="border-bottom: 1px solid;"><?=lang('price');?></th>
                                            <? if ($Settings->show_itemdiscount) { ?>
                                            <th class="text-right" style="border-bottom: 1px solid;"><?=lang('discount');?></th>
                                            <? } ?>
                                            <th class="text-right" style="border-bottom: 1px solid;"><?=lang('subtotal');?></th>
                                        </tr>
                                    </thead>
                                    <tbody class="mytbody">
                                        <?php
                                        $tax_summary = array();
                                        $counter = 1;
                                        foreach ($rows as $row) {
                                            echo '<tr>
													<td style="text-align:center;">'. $counter . '</td>
													<td>' . $row->product_name . '<br><small>' . $row->comment . '</small></td>';
                                            echo '<td style="text-align:center;">' . $this->tec->formatQuantity($row->quantity) . '</td>';
                                            if ($Settings->show_unit) {
                                            echo '<td style="text-align:center;">' . $row->unit . '</td>';
                                            }
                                            echo '<td class="text-right">';
                                            if ($Settings->show_itemdiscount) {
                                            echo $this->tec->formatMoney($row->real_unit_price + ($row->item_tax / $row->quantity)) . '</td><td class="text-right">' . ($row->discount != 0 ? $row->discount : $this->tec->formatMoney($row->item_discount)) . '</td><td class="text-right">' . $this->tec->formatMoney($row->subtotal) . '</td></tr>';
                                            } else {
                                            echo $this->tec->formatMoney($row->net_unit_price + ($row->item_tax / $row->quantity)) . '</td><td class="text-right">' . $this->tec->formatMoney($row->subtotal) . '</td></tr>';           
                                            }    
                                            $counter ++;                             
                                        }
                                        ?>
                                    </tbody>
                                </table>
                                <table class="table table-striped table-condensed">
                                        <tr>
                                            <th><?= lang("total"); ?></th>
											
											
											<th class="text-right"><?= $this->tec->formatQuantity( $inv->total_items); ?> (<?= $this->tec->formatQuantity( $inv->total_quantity); ?>)</th>
											
											
                                            <th class="text-right"><?= $this->tec->formatMoney($inv->total + $inv->product_tax); ?></th>
                                        </tr>
                                        <?php
                                        if ($inv->order_tax != 0) {
                                            echo '<tr><th colspan="2" class="text-right">' . lang("order_tax") . '</th><th class="text-right">' . $this->tec->formatMoney($inv->order_tax) . '</th></tr>';
                                        }
                                        if ($Settings->show_inclusive_tax) {
                                            echo '<tr><th colspan="2" class="text-right">' . lang("tax") . '</th><th class="text-right">' . $this->tec->formatMoney($inv->product_tax) . '</th></tr>';
                                        }
                                        if ($inv->total_discount != 0) {
                                            echo '<tr><th colspan="2" class="text-right">' . lang("order_discount") . '</th><th class="text-right">' . $this->tec->formatMoney($inv->total_discount) . '</th></tr>';
                                        }

                                        if ($Settings->rounding) {
                                            $round_total = $this->tec->roundNumber($inv->grand_total, $Settings->rounding);
                                            $rounding = $this->tec->formatDecimal($round_total - $inv->grand_total);
                                            ?>
                                            <tr>
                                                <th colspan="2" class="text-right"><?= lang("rounding"); ?> (<?=$Settings->symbol?>)</th>
                                                <th class="text-right"><?= $this->tec->formatMoney($rounding); ?></th>
                                            </tr>
                                            <tr class="mytotal">
                                                <th colspan="2" class="text-right"><?= lang("grand_total"); ?></th>
                                                <th class="text-right"><?= $this->tec->formatMoney($inv->grand_total + $rounding); ?></th>
                                            </tr>
											<?php if ($Settings->exchange_rate > 0) { ?>
                                            <?php 
                                                if ($Settings->exchange_rate_multiply == '*') {
                                                    $grand_total_local_currency = $inv->grand_total * $Settings->exchange_rate;
                                                }
                                                else{
                                                    $grand_total_local_currency = $inv->grand_total / $Settings->exchange_rate;
                                                }                                              
                                            ?>
											<tr>
                                                <th colspan="2" class="text-right"><?= lang("grand_total"); ?> (<?=$Settings->exchange_rate_symbol?>)</th>
                                                <th class="text-right"><?=$this->tec->formatMoneyExc($grand_total_local_currency,$Settings->exchange_rate_symbol); ?></th>
												
                                            </tr>
											<?php } ?>
											<?php if ($Settings->exchange_rate2 > 0) { ?>
                                                <?php 
                                                if ($Settings->exchange_rate2_multiply == '*') {
                                                    $grand_total_local_currency2 = $inv->grand_total * $Settings->exchange_rate2;
                                                }
                                                else{
                                                    $grand_total_local_currency2 = $inv->grand_total / $Settings->exchange_rate2;
                                                }                                              
                                            ?>
											<tr>
                                                <th colspan="2" class="text-right"><?= lang("grand_total"); ?> (<?=$Settings->exchange_rate2_symbol?>)</th>
                                                <th class="text-right"><?=$this->tec->formatMoneyExc($grand_total_local_currency2,$Settings->exchange_rate2_symbol); ?></th>
												
                                            </tr>
											<?php } ?>
                                            <?php
                                        } else {
                                            $round_total = $inv->grand_total;
                                            ?>
                                            <tr class="mytotal">
                                                <th colspan="2" class="text-right"><?= lang("grand_total"); ?> (<?=$Settings->symbol?>)</th>
                                                <th class="text-right"><?= $this->tec->formatMoney($inv->grand_total); ?></th>
                                            </tr>
											<?php if ($Settings->exchange_rate > 0) { ?>
                                            <?php 
                                                if ($Settings->exchange_rate_multiply == '*') {
                                                    $grand_total_local_currency = $inv->grand_total * $Settings->exchange_rate;
                                                }
                                                else{
                                                    $grand_total_local_currency = $inv->grand_total / $Settings->exchange_rate;
                                                }                                              
                                            ?>
											<tr>
                                                <th colspan="2" class="text-right"><?= lang("grand_total"); ?> (<?=$Settings->exchange_rate_symbol?>)</th>
                                                <th class="text-right"><?=$this->tec->formatMoneyExc($grand_total_local_currency,$Settings->exchange_rate_symbol); ?></th>
												
                                            </tr>
											<?php } ?>
											<?php if ($Settings->exchange_rate2 > 0) { ?>
                                                <?php 
                                                if ($Settings->exchange_rate2_multiply == '*') {
                                                    $grand_total_local_currency2 = $inv->grand_total * $Settings->exchange_rate2;
                                                }
                                                else{
                                                    $grand_total_local_currency2 = $inv->grand_total / $Settings->exchange_rate2;
                                                }                                              
                                            ?>
											<tr>
                                                <th colspan="2" class="text-right"><?= lang("grand_total"); ?> (<?=$Settings->exchange_rate2_symbol?>)</th>
                                                <th class="text-right"><?=$this->tec->formatMoneyExc($grand_total_local_currency2,$Settings->exchange_rate2_symbol); ?></th>
												
                                            </tr>
											<?php } ?>
                                            <?php
                                        }
                                        if ($inv->paid < $round_total) { ?>
                                        <tr>
                                            <th colspan="2" class="text-right"><?= lang("paid_amount"); ?></th>
                                            <th class="text-right"><?= $this->tec->formatMoney($inv->paid); ?></th>
                                        </tr>
                                        <tr>
                                            <th colspan="2" class="text-right"><?= lang("due_amount"); ?></th>
                                            <th class="text-right"><?= $this->tec->formatMoney($inv->grand_total - $inv->paid); ?></th>
                                        </tr>
                                        <?php } ?>
                                    
                                </table>
                                <?php
                                
								if ($payments) {
                                    echo '<table class="well well-sm" style="margin-top:10px; width:100%;"><tbody>';
									foreach ($payments as $payment) {
                                        echo '<tr>';
                                        if ($payment->paid_by == 'cash' && $payment->pos_paid) {
                                            echo '<tr><th colspan="2" class="text-right">' . lang("amount") . ' ('. $Settings->symbol .'): </th>';
                                            if ($Settings->show_exc_paid){
                                                echo '<th class="text-right" width="40%">' . $this->tec->formatMoney($payment->pos_paid_main) . '</th></tr>';
                                            } else {
                                                echo '<th class="text-right" width="40%">' . $this->tec->formatMoney($payment->pos_paid == 0 ? $payment->amount : $payment->pos_paid) . '</th></tr>';
                                            }                                            
                                            if ($Settings->exchange_rate>0) {												
                                                echo '<tr><th colspan="2" class="text-right">' . lang("amount") . ' ('. $Settings->exchange_rate_symbol .'): </th>';
                                                if ($Settings->show_exc_paid){
                                                    echo '<th class="text-right" width="40%">' . $this->tec->formatMoneyExc($payment->pos_paid_exc,$Settings->exchange_rate_symbol) . '</th></tr>';
                                                } else {
                                                    if ($Settings->exchange_rate_multiply == '*') {
                                                        echo '<th class="text-right" width="40%">'. $this->tec->formatMoneyExc($payment->pos_paid == 0 ? $payment->amount : $payment->pos_paid * $Settings->exchange_rate,$Settings->exchange_rate_symbol) . '</th></tr>';	
                                                    }else{
                                                        echo '<th class="text-right" width="40%">'. $this->tec->formatMoneyExc($payment->pos_paid == 0 ? $payment->amount : $payment->pos_paid / $Settings->exchange_rate,$Settings->exchange_rate_symbol) . '</th></tr>';
                                                    } 
                                                }                                               
                                            }
                                            if ($Settings->exchange_rate2>0) {												
                                                echo '<tr><th colspan="2" class="text-right">' . lang("amount") . ' ('. $Settings->exchange_rate2_symbol .'): </th>';
                                                if ($Settings->show_exc_paid){
                                                    echo '<th class="text-right" width="40%">' . $this->tec->formatMoneyExc($payment->pos_paid_exc2,$Settings->exchange_rate2_symbol) . '</th></tr>';
                                                } else {
                                                    if ($Settings->exchange_rate2_multiply == '*') {
                                                        echo '<th class="text-right" width="40%">'. $this->tec->formatMoneyExc($payment->pos_paid == 0 ? $payment->amount : $payment->pos_paid * $Settings->exchange_rate2,$Settings->exchange_rate2_symbol) . '</th></tr>';	
                                                     }else{
                                                        echo '<th class="text-right" width="40%">'. $this->tec->formatMoneyExc($payment->pos_paid == 0 ? $payment->amount : $payment->pos_paid / $Settings->exchange_rate2,$Settings->exchange_rate2_symbol) . '</th></tr>';
                                                    }
                                                }                                                    
                                            }
                                            echo '</tbody></table>';
                                            echo '<table class="well well-sm" style="margin-top:3px; width:100%;"><tbody>';
											echo '<tr><th colspan="2" class="text-right">' . lang("change") . ' ('. $Settings->symbol .'): </th>';
                                            echo '<th class="text-right" width="40%">' . ($payment->pos_balance > 0 ? $this->tec->formatMoney($payment->pos_balance) : 0) . '</th></tr>';
                                            if ($Settings->exchange_rate>0) {	
											    echo '<tr><th colspan="2" class="text-right">' . lang("change") . ' ('. $Settings->exchange_rate_symbol .'): </th>';
                                                if ($Settings->exchange_rate_multiply == '*') {
                                                    echo '<th class="text-right" width="40%">' . $this->tec->formatMoneyExc($payment->pos_balance  * $Settings->exchange_rate,$Settings->exchange_rate_symbol) . '</th></tr>';												
                                                }else{
                                                    echo '<th class="text-right" width="40%">' . $this->tec->formatMoneyExc($payment->pos_balance  / $Settings->exchange_rate,$Settings->exchange_rate_symbol) . '</th></tr>';
                                                }
                                            }
                                            if ($Settings->exchange_rate2>0) {	
											    echo '<tr><th colspan="2" class="text-right">' . lang("change") . ' ('. $Settings->exchange_rate2_symbol .'): </th>';
                                                if ($Settings->exchange_rate2_multiply == '*') {
                                                    echo '<th class="text-right" width="40%">' . $this->tec->formatMoneyExc($payment->pos_balance  * $Settings->exchange_rate2,$Settings->exchange_rate2_symbol) . '</th></tr>';												
                                                }else{
                                                    echo '<th class="text-right" width="40%">' . $this->tec->formatMoneyExc($payment->pos_balance  / $Settings->exchange_rate2,$Settings->exchange_rate2_symbol) . '</th></tr>';
                                                }
                                            }
                                            if ($Settings->show_changedecimal){
                                                echo '</tbody></table>';
                                                echo '<table class="well well-sm" style="margin-top:3px; width:100%;"><tbody>';
                                                if ($Settings->exchange_rate>0) {	
                                                    echo '<tr><th colspan="2" class="text-right">' . lang("change_decimal") . ' ('. $Settings->exchange_rate_symbol .'): </th>';
                                                    echo '<th class="text-right" width="40%">' . $this->tec->formatMoney($payment->pos_balance-floor($payment->pos_balance)) . ' = ' . ((($payment->pos_balance-floor($payment->pos_balance))*$Settings->exchange_rate) > 0 ? $this->tec->formatMoneyExc(($payment->pos_balance-floor($payment->pos_balance))*$Settings->exchange_rate,$Settings->exchange_rate_symbol) : 0) . '</th></tr>';											
                                                }
                                                if ($Settings->exchange_rate2>0) {	
                                                    echo '<tr><th colspan="2" class="text-right">' . lang("change_decimal") . ' ('. $Settings->exchange_rate2_symbol .'): </th>';
                                                    echo '<th class="text-right" width="40%">' . $this->tec->formatMoney($payment->pos_balance-floor($payment->pos_balance)) . ' = ' . ((($payment->pos_balance-floor($payment->pos_balance))*$Settings->exchange_rate2) > 0 ? $this->tec->formatMoneyExc(($payment->pos_balance-floor($payment->pos_balance))*$Settings->exchange_rate2,$Settings->exchange_rate2_symbol) : 0) . '</th></tr>';											
                                                }
                                            }
                                        }
                                        if (($payment->paid_by == 'CC' || $payment->paid_by == 'ppp' || $payment->paid_by == 'stripe') && $payment->cc_no) {
                                            /* echo '<td class="text-right">' . lang("paid_by") . ' :</td><td>' . lang($payment->paid_by) . '</td>'; */
                                            echo '<td class="text-right">' . lang("amount") . ' :</td><td>' . $this->tec->formatMoney($payment->pos_paid) . '</td>';
                                            echo '<td class="text-right">' . lang("no") . ' :</td><td>' . 'xxxx xxxx xxxx ' . substr($payment->cc_no, -4) . '</td>';
                                            echo '<td class="text-right">' . lang("name") . ' :</td><td>' . $payment->cc_holder . '</td>';
                                        }
                                        if ($payment->paid_by == 'Cheque' || $payment->paid_by == 'cheque' && $payment->cheque_no) {
                                            /* echo '<td class="text-right">' . lang("paid_by") . ' :</td><td>' . lang($payment->paid_by) . '</td>'; */
                                            echo '<td class="text-right">' . lang("amount") . ' :</td><td>' . $this->tec->formatMoney($payment->pos_paid) . '</td>';
                                            echo '<td class="text-right">' . lang("cheque_no") . ' :</td><td>' . $payment->cheque_no . '</td>';
                                        }
                                        if ($payment->paid_by == 'gift_card' && $payment->pos_paid) {
                                            /* echo '<td class="text-right">' . lang("paid_by") . ' :</td><td>' . lang($payment->paid_by) . '</td>'; */
                                            echo '<td class="text-right">' . lang("no") . ' :</td><td>' . $payment->gc_no . '</td>';
                                            echo '<td class="text-right">' . lang("amount") . ' :</td><td>' . $this->tec->formatMoney($payment->pos_paid) . '</td>';
                                            echo '<td class="text-right">' . lang("balance") . ' :</td><td>' . ($payment->pos_balance > 0 ? $this->tec->formatMoney($payment->pos_balance) : 0) . '</td>';
                                        }
                                        if ($payment->paid_by == 'other' && $payment->amount) {
                                            echo '<td class="text-right">' . lang("paid_by") . ' :</td><td>' . lang($payment->paid_by) . '</td>';
                                            echo '<td class="text-right">' . lang("amount") . ' :</td><td>' . $this->tec->formatMoney($payment->pos_paid == 0 ? $payment->amount : $payment->pos_paid) . '</td>';
                                            echo $payment->note ? '</tr><td colspan="2">' . lang("payment_note") . ' :</td><td>' . $payment->note . '</td>' : '';
                                        }
                                        echo '</tr>';
                                    }
                                    echo '</tbody></table>';
                                }

                                ?>							

                                <?= $inv->note ? '<p style="margin-top:5px; text-align: center;">' . $this->tec->decode_html($inv->note) . '</p>' : ''; ?>
                                <?php if (!empty($store->receipt_footer)) { ?>
                                <div class="well-sm"  style="margin-top:5px;">
                                    <div style="text-align: center;"><?= nl2br($store->receipt_footer); ?></div>
                                </div>
                                <?php } ?>
                            </div>
                            <div style="clear:both;"></div>
                        </div>

                        <!-- start -->
                        <div id="buttons" style="padding-top:10px; text-transform:uppercase;" class="no-print">
                            <hr>
                            <?php if ($modal) { ?>
                            <div class="btn-group btn-group-justified" role="group" aria-label="...">
                                <div class="btn-group" role="group">
                                    <?php
                                    if ( ! $Settings->remote_printing) {
                                        echo '<a href="'.site_url('pos/print_receipt/'.$inv->id.'/0').'" id="print" class="btn btn-block btn-primary">'.lang("print").'</a>';
                                    } elseif ($Settings->remote_printing == 1) {
                                        echo '<button onclick="window.print();" class="btn btn-block btn-primary">'.lang("print").'</button>';                                        
                                    } elseif ($Settings->remote_printing == 3) {
                                        echo '<a href="'.site_url('pos/pdf_receipt/'.$inv->id.'/0').'" id="print" class="btn btn-block btn-primary">'.lang("print").'</a>';
                                    } else {
                                        echo '<button onclick="return printReceipt()" class="btn btn-block btn-primary">'.lang("print").'</button>';
                                    }
                                    ?>
                                </div>
                                <div class="btn-group" role="group">
                                    <a class="btn btn-block btn-success" href="#" id="email"><?= lang("email"); ?></a>
                                </div>
                                <div class="btn-group" role="group">
                                    <button type="button" class="btn btn-default" data-dismiss="modal"><?= lang('close'); ?></button>
                                </div>
                            </div>
                            <?php } else { ?>
                            <span class="pull-right col-xs-12">
                                <?php
                                if ( ! $Settings->remote_printing) {
                                    echo '<a href="'.site_url('pos/print_receipt/'.$inv->id.'/1').'" id="print" class="btn btn-block btn-primary">'.lang("print").'</a>';
                                    echo '<a href="'.site_url('pos/open_drawer/').'" class="btn btn-block btn-default">'.lang("open_cash_drawer").'</a>';
                                } elseif ($Settings->remote_printing == 1) {
                                    echo '<button onclick="window.print();" class="btn btn-block btn-primary">'.lang("print").'</button>';                                    
                                    echo '<a href="#" id="image" class="btn btn-block btn-warning">'.lang("save_image").'</a>';
                                } elseif ($Settings->remote_printing == 3) {
                                    echo '<a href="'.site_url('pos/pdf_receipt/'.$inv->id.'/0').'" id="print" class="btn btn-block btn-primary">'.lang("print").'</a>';
                                } else {
                                    echo '<button onclick="return printReceipt()" class="btn btn-block btn-primary">'.lang("print").'</button>';
                                    echo '<button onclick="return openCashDrawer()" class="btn btn-block btn-default">'.lang("open_cash_drawer").'</button>';
                                }
                                
                                ?>
                            </span>
                            <?//<span class="pull-left col-xs-12"><a class="btn btn-block btn-success" href="#" id="email"><?= lang("email"); ?></a></span>
                            <?php
                            if($Settings->print_customer_label){
                                if($Settings->remote_printing==1){
                                    echo '<button onclick="return printLabel()" class="btn btn-block btn-primary">'.lang("print").' Label</button>';
                                }else if($Settings->remote_printing==3){
                                    echo '<a href="'.site_url('pos/label_customer/'.$inv->id).'" id="labelprint" class="btn btn-block btn-primary">'.lang("Print_Delivery_Label_60x40").'</a>'; 
                                }
                            }
                            ?>
                            <span class="pull-left col-xs-12"><a class="btn btn-block btn-success" href="<?= site_url('sales'); ?>"><?= lang("back_to_sales"); ?></a></span>							
                            <?php } ?>
                            <div style="clear:both;"></div>
                            <div id="delivery_tbl" style="overflow:hidden; max-height:0; margin: 0 auto;">
                                <table width="100%"> 
                                    <tr>  
                                        <td> <?= lang("name").': '. $inv->customer_name; ?> </td>								 
                                    </tr>
                                    <tr>
                                        <td style="text-align:left;font-size:18px"><?= lang("phone").': '. $customer->phone; ?> </td>
                                    </tr>
                                    <tr>	
                                        <td><?= lang("address").': '. $customer->cf1; ?></td>
                                    </tr>
                                    <tr>
                                        <td><?= lang("date").': '.$this->tec->hrld($inv->date); ?></td>
                                    </tr>
                                    <tr>
                                        <td> <?= lang("total").': '. $this->tec->formatMoney($inv->total); ?></td>
                                    </tr>
                                    <tr>	
                                        <td> <?= $this->tec->decode_html($inv->note); ?></td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                        <!-- end -->
                    </div>
                </div>
                <!-- start -->
                <?php
                if (!$modal) {
                    ?>
                    <script type="text/javascript">
                        var base_url = '<?=base_url();?>';
                        var site_url = '<?=site_url();?>';
                        var dateformat = '<?=$Settings->dateformat;?>', timeformat = '<?= $Settings->timeformat ?>';
                        <?php unset($Settings->protocol, $Settings->smtp_host, $Settings->smtp_user, $Settings->smtp_pass, $Settings->smtp_port, $Settings->smtp_crypto, $Settings->mailpath, $Settings->timezone, $Settings->setting_id, $Settings->default_email, $Settings->version, $Settings->stripe, $Settings->stripe_secret_key, $Settings->stripe_publishable_key); ?>
                        var Settings = <?= json_encode($Settings); ?>;
                    </script>
                    <script src="<?= $assets ?>plugins/jQuery/jQuery-2.1.4.min.js"></script>
                    <script src="<?= $assets ?>dist/js/libraries.min.js" type="text/javascript"></script>
                    <script src="<?= $assets ?>dist/js/scripts.min.js" type="text/javascript"></script>
                    <?php
                }
                ?>
                <script type="text/javascript">
                    $(document).ready(function () {
                        $('#print').click(function (e) {
                            e.preventDefault();
                            var link = $(this).attr('href');
                            $.get(link);
                            return false;
                        });
                        $('#labelprint').click(function (e) {
                            e.preventDefault();
                            var link = $(this).attr('href');
                            $.get(link);
                            return false;
                        });
                        $('#email').click(function () {
                            bootbox.prompt({
                                title: "<?= lang("email_address"); ?>",
                                inputType: 'email',
                                value: "<?= $customer->email; ?>",
                                callback: function (email) {
                                    if (email != null) {
                                        $.ajax({
                                            type: "post",
                                            url: "<?= site_url('pos/email_receipt') ?>",
                                            data: {<?= $this->security->get_csrf_token_name(); ?>: "<?= $this->security->get_csrf_hash(); ?>", email: email, id: <?= $inv->id; ?>},
                                            dataType: "json",
                                            success: function (data) {
                                                bootbox.alert({message: data.msg, size: 'small'});
                                            },
                                            error: function () {
                                                bootbox.alert({message: '<?= lang('ajax_request_failed'); ?>', size: 'small'});
                                                return false;
                                            }
                                        });
                                    }
                                }
                            });
                            return false;
                        });
                        <?php if ($Settings->remote_printing != 3) {?> 
                        $('#image').click(function (event) {
                            event.preventDefault(); 
                            window.scrollTo(0,0);
                            html2canvas(document.querySelector("#receipt-data")).then(function(canvas) {
                                var img = canvas.toDataURL();
                                var imgwindow = window.open('', 'sma_pos_img');
                                imgwindow.document.write('<html><head><title>Screenshot</title>');
                                imgwindow.document.write('<img src="' + img + '" class="img-thumbnail"/>');
                                imgwindow.document.write('</body></html>');
                                return true;
                            });                            
                            return false;
                        });
                        <?php } ?>
                    });
					<?php
					if ($Settings->auto_print == 1 && $Settings->remote_printing == 1) {
						?>
						$(window).load(function () {
                            setTimeout(function() {
								window.print();  
							}, 300);
							return true;      
						});
						<?php
					} else if ($Settings->auto_print == 2) {
                        ?>
						$(window).load(function () {
                            setTimeout(function() {
								window.print();  
                                document.location.href = "pos";
							}, 300);
							return true;      
						});
						<?php
                    }
                    ?>
                    function doPrint() {
                        window.print();            
                        document.location.href = "pos"; 
                    }
                    function printLabel() {
                            if (Settings.remote_printing == 1) {                                
                                printJS({
                                    printable:'delivery_tbl',
                                    type:'html',
                                    font_size: '15px;',
                                    style:'@page{margin:5px 10px 5px 5px;} * { -webkit-print-color-adjust: exact !important; /* Chrome, Safari */ color-adjust: exact !important; /*Firefox*/ } body{font-family:"Battambang", "Khmer OS Battambang"; font-size:10px; line-height: 1.5;} h5{margin:5px; font-size:11px; font-weight:normal;} table{font-size:10px; border-collapse: collapse;} table.table thead tr th{background-color:#000 !important; color:#fff !important; padding:5px 10px;} table#bill-table{border-bottom: 1px solid; border-top: 1px solid; margin-top:10px;} table#order-table{border-bottom: 1px solid; border-top: 1px solid; width:100%; margin-top:10px;} p{margin:5px 0;} .text-center{text-align:center;} .text-left{text-align:left;} .text-right{text-align:right;} td.my-total{font-weight:bold; background-color:#000; font-size:12px; color:#fff;} td{padding:5px;} div#qrcode{text-align:center;}'
                                });                                                           
                            } else if (Settings.remote_printing == 3) {
                                
                            }
                    }
                </script>
                <?php /* include FCPATH.'themes'.DIRECTORY_SEPARATOR.$Settings->theme.DIRECTORY_SEPARATOR.'views'.DIRECTORY_SEPARATOR.'pos'.DIRECTORY_SEPARATOR.'remote_printing.php'; */ ?>
                <?php include 'remote_printing.php'; ?>
                <?php
                if ($modal) {
                    ?>
                </div>
            </div>
        </div>
        <?php
    } else {
        ?>
    <!-- end -->
    </body>
    </html>
    <?php
}
?>
