<?php (defined('BASEPATH')) OR exit('No direct script access allowed'); ?>

<?php
if ($modal) {
    ?>
    <div class="modal-dialog" role="document"<?= $Settings->rtl ? ' dir="rtl"' : ''; ?>>
        <div class="modal-content">
            <div class="modal-body">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"><i class="fa fa-times"></i></button>
                <?php
            } else {
                ?><!doctype html>
                <html<?= $Settings->rtl ? ' dir="rtl"' : ''; ?>>
                <head>
                    <meta charset="utf-8">
                    <title><?= $page_title . " " . lang("no") . " " . $inv->id; ?></title>
                    <base href="<?= base_url() ?>"/>
                    <meta http-equiv="cache-control" content="max-age=0"/>
                    <meta http-equiv="cache-control" content="no-cache"/>
                    <meta http-equiv="expires" content="0"/>
                    <meta http-equiv="pragma" content="no-cache"/>
                    <link rel="shortcut icon" href="<?= $assets ?>images/icon.png"/>
                    <style type="text/css" media="all">
                        @page {
                            margin: 2px 15px;
                        }
                        body { 
							color: #000; 
							font-family: "Khmer OS Battambang";
							font-size: <?= $Settings->receipt_font_size .'px';?>;
							line-height: 1.42857143;
							margin: 0 5px;
						}
						p {
							margin:5px 0;
						}
						.text-right {
							text-align: right;
                            padding-right: 10px !important;
						}
                        #wrapper { max-width: 480px; margin: 0 auto; padding-top: 20px; }
                        .btn { margin-bottom: 5px; }
                        .table { border-radius: 3px; width:100%; border-collapse: collapse; margin-top:10px; margin-bottom:-10px;}
                        thead.mythead, tr.mythead {color:#000; }
                        tr.mythead, tr.mytotal {color:#fff !important; background-color:#fff;}
                        tr.mythead th, tr.mytotal th {color:#000 !important;}
                        tr.mytotal th {font-size: <?= $Settings->receipt_font_size+2 .'px';?>;}
                        tr.mythead th.text-right {padding-right:10px !important;}
						thead.mythead th { padding:10px 0; color:#000 !important;}
						tfoot.mytfoot { border-top: 1px solid #000;}
                        .table th, .table td { vertical-align: middle !important; padding:5px; border-top:1px solid;}
                        h3 { margin: 5px 0; }
						a {
							text-decoration: none;
							color: #fff;
						}
						.btn-primary {
							background-color: #3c8dbc;
							border-color: #367fa9;
						}
						.btn-success {
							background-color: #00a65a;
							border-color: #008d4c;
						}
						.btn-warning {
							background-color: #f39c12;
							border-color: #e08e0b;
						}
						.btn-block {
							display: block;
							width: 100%;
						}
						.btn-primary {
							color: #fff;
						}
						.btn {
							border-radius: 3px;
                            font-family: "Khmer OS Battambang";
							margin-bottom: 5px;
							-webkit-box-shadow: none;
							box-shadow: none;
							border: 0px solid transparent;
							display: inline-block;
							padding: 6px 0;
							margin-bottom: 0;
							font-size: 14px;
							font-weight: 400;
							line-height: 1.42857143;
							text-align: center;
							white-space: nowrap;
							-ms-touch-action: manipulation;
							touch-action: manipulation;
							cursor: pointer;
							-webkit-user-select: none;
							-moz-user-select: none;
							-ms-user-select: none;
							user-select: none;
							margin-bottom: 5px;
						}
						.well-sm {
							padding: 5px;
							border-radius: 3px;
						}
						.well {
							min-height: 20px;
							border: 1px solid #000;
							border-radius: 4px;
							-webkit-box-shadow: inset 0 1px 1px rgba(0,0,0,.05);
							box-shadow: inset 0 1px 1px rgba(0,0,0,.05);
						}
						.alert-success {
							background-color: #00a65a!important;
							border-color: #008d4c!important;
						}
						.alert, .callout {
							border-radius: 3px;
						}
						.alert {
							padding: 15px;
							border: 1px solid transparent;
						}
						.alert, .thumbnail {
							margin-bottom: 20px;
						}
						.alert .close {
							color: #000;
							opacity: .2;
							filter: alpha(opacity=20);
						}
						button.close {
							-webkit-appearance: none;
							padding: 0;
							cursor: pointer;
							background: 0 0;
							border: 0;
						}
						.close {
							float: right;
							font-size: 21px;
							line-height: 1;
							color: #000;
							text-shadow: 0 1px 0 #fff;
							filter: alpha(opacity=20);
							opacity: .2;
						}
                        a[href^=tel] {
                            color: inherit;
                            text-decoration: none;
                        }
						.alert .alert-link, .close {
							font-weight: 700;
						}						
                        @media print {
                            .no-print { display: none; }
                            #wrapper { max-width: 700px; min-width: 250px; margin: 0 auto;}						
                        }
                        <?php if($Settings->rtl) { ?>
                            .text-right { text-align: left; }
                            .text-left { text-align: right; }
                            tfoot tr th:first-child { text-align: left; }
                        <?php } else { ?>
                            tfoot tr th:first-child { text-align: right; }
                        <?php } ?>
                    </style>
                </head>
                <body>
                    <?php
                }
                ?>
                <div id="wrapper">
                    <div id="receiptData" style="width: auto; max-width: 700px; min-width: 250px; margin: 0 auto;">
                        <div class="no-print">
                            <span class="col-xs-12">
                                <a class="btn btn-block btn-warning" style="padding-top:20px; padding-bottom:20px; font-size:20px;" href="<?= site_url('pos'); ?>"><?= lang("back_to_pos"); ?></a>
                            </span>
                        </div>
                        <div id="receipt-data">
                            <div>
                                <div style="text-align:center;">
                                    <?php
                                    if ($store) {
                                        if (!empty($store->logo)) {
										echo '<img src="'.base_url('uploads/'.$store->logo).'" alt="'.$store->name.'">';
										}
                                        echo '<p style="text-align:center; font-size:22px;">'; 
                                        echo '<strong>' . nl2br($store->name) . '</strong></p>';                            
                                        
                                    }                                    
                                    ?>
                                    <?php
                                    if($Settings->show_waiting_number){
                                    echo '<p style="margin:0;">'.lang(waiting_number).':</p>';
                                    echo '<p style="margin:0; font-size:20px; font-weight:bold;">'.$inv->waiting_number.'</p>';
                                    }
                                    ?>
                                </div>
								
								<table>
									<tr>
										<td style="font-size:18px"><?= lang('sale_no_ref').': '.$inv->id; ?></td>
										
										
									</tr>
									<tr>
										
										<td style="font-size:18px"><?= lang("customer").': '. $inv->customer_name; ?></td>
										
									</tr>
									<tr>
										
										<td style="font-size:15px">     <?= lang("date").': '.$this->tec->hrld($inv->date); ?> <br></td>
										
									</tr>
								
								</table>
                            
                                <div style="clear:both;"></div>
                                <table width="100%">
                                    <thead class="mythead">
                                        <tr class="mythead">
                                          
                                            <th class="text-center" style="width: 60%; border-bottom: 1px solid; font-size: 15px"><?=lang('des             price');?></th>
                                            <th class="text-center" style="border-bottom: 1px solid;font-size: 15px"><?=lang('qty');?></th>
                                          
                                            <th class="text-right" style="border-bottom: 1px solid;font-size: 15px"><?=lang('total');?></th>
                                        </tr>
                                    </thead>
                                    <tbody class="mytbody">
                                        <?php
                                        $tax_summary = array();
                                        $counter = 1;
                                        foreach ($rows as $row) {
                                            echo '<tr>
												
													<td collapse="3" style="font-size:15px;width=200px">' . $row->product_name . '</td>
                                                                                  
                                           </tr>'; 

											echo '<tr>
												
													<td collapse="2" style="font-size:15px; width="100px"; class="text-right">' . $this->tec->formatMoney($row->real_unit_price - $row->item_discount) . '</td>';
                                            echo '<td style="text-align:center;font-size:15px">' . $this->tec->formatQuantity($row->quantity) . '</td>';
                                           
                                            echo '<td class="text-right"  style="font-size:15px">';
                                         
                                            echo $this->tec->formatMoney($row->subtotal) . '</td></tr>'; 
											
                                               
                                            $counter ++;                             
                                        }
                                        ?>
                                    </tbody>
                                </table>
                                <table class="table table-striped table-condensed" style="margin-bottom:3px;">
                                      
                                        <?php
                                       
                                        

                                        if ($Settings->rounding) {
                                            $round_total = $this->tec->roundNumber($inv->grand_total, $Settings->rounding);
                                            $rounding = $this->tec->formatDecimal($round_total - $inv->grand_total);
                                            ?>
                                           
											
										
                                            <?php
                                        } else {
                                            $round_total = $inv->grand_total;
                                            ?>
                                           
										
											
                                            <?php
                                        }
                                        if ($inv->paid < $round_total) { ?>
                                       
                                       
                                        <?php } ?>
                                    
                                </table>
                                <?php
                                
								if ($payments) {
                                    
									foreach ($payments as $payment) {
                                        echo '<table class="table table-striped table-condensed"><tbody>';
                                        echo '<tr>';
                                        //if ($payment->paid_by == 'cash' && $payment->pos_paid) {
                                        if ($payment->amount) {
											
											 echo '<tr><th colspan="2" class="text-right" style="font-size:18px">' . lang("ប្រាក់សរុប") . ' ('. $Settings->symbol .'): </th>';
                                          
                                                echo '<th class="text-right" width="40%" style="font-size:18px">' . $this->tec->formatMoney($inv->grand_total+$inv->total_discount) . '</th></tr>';
											
											
											  echo '<tr><th colspan="2" class="text-right" style="font-size:18px">' . lang("បញ្ចុះតម្លៃ") . ' ('. $Settings->symbol .'):</th><th class="text-right"​ style="font-size:18px">' . $this->tec->formatMoney($inv->total_discount) . '</th></tr>';
											  
											
											 echo '<tr><th colspan="2" class="text-right" style="font-size:18px">' . lang("ប្រាក់នៅសល់") . ' ('. $Settings->symbol .'): </th>';
                                          
                                                echo '<th class="text-right" width="40%" style="font-size:18px">' . $this->tec->formatMoney($inv->grand_total) . '</th></tr>';
												
												
                                         
										   
                                            echo '<tr><th colspan="2" class="text-right" style="font-size:18px">' . lang("ប្រាក់ទទួល") . ' ('. $Settings->symbol .'): </th>';
                                          
                                                echo '<th class="text-right" width="40%" style="font-size:18px">' . $this->tec->formatMoney($payment->pos_paid == 0 ? $payment->amount : $payment->pos_paid_main) . '</th></tr>';
                                           
                                          
                                         
                                          
											echo '<tr><th colspan="2" class="text-right" style="font-size:18px">' . lang("ប្រាក់អាប់") . ' ('. $Settings->symbol .'): </th>';
                                            echo '<th class="text-right" width="40%" style="font-size:18px">' . ($payment->pos_balance > 0 ? $this->tec->formatMoney($payment->pos_balance) : $this->tec->formatMoney(0)) . '</th></tr>';
                                            
											   
                                               											
                                                
                                            }
                                          
                                                                                  
                                        
                                        echo '</tbody></table>';
                                        
                                    }
                                }

                                ?>							

                                <?= $inv->note ? '<p style="margin-top:5px; text-align: center;">' . $this->tec->decode_html($inv->note) . '</p>' : ''; ?>
                                <?php if (!empty($store->receipt_footer)) { ?>
                                <div class="well-sm"  style="margin-top:5px;">
                                    <div style="text-align: center;"><?= nl2br($store->receipt_footer); ?></div>
                                </div>
                                <?php } ?>
                                <? if ($Settings->show_refbarcode == 2 || $Settings->show_refbarcode == 3 ) { ?>
                                <div id="barcode" style="text-align:center;"><?= $saleid_barcode ?></div>
                                <? } ?> 
                            </div>
                            <div style="clear:both;"></div>
                        </div>

                        <!-- start -->
                        <div id="buttons" style="padding-top:10px; text-transform:uppercase;" class="no-print">
                            <hr>
                            <?php if ($modal) { ?>
                            <div class="btn-group btn-group-justified" role="group" aria-label="...">
                                <div class="btn-group" role="group">
                                    <?php
                                    if ( ! $Settings->remote_printing) {
                                        echo '<a href="'.site_url('pos/print_receipt/'.$inv->id.'/0').'" id="print" class="btn btn-block btn-primary">'.lang("print").'</a>';
                                    } elseif ($Settings->remote_printing == 1) {
                                        echo '<button onclick="window.print();" class="btn btn-block btn-primary">'.lang("print").'</button>';                                        
                                    } elseif ($Settings->remote_printing == 3) {
                                        echo '<a href="'.site_url('pos/pdf_receipt/'.$inv->id.'/0').'" id="print" class="btn btn-block btn-primary">'.lang("print").'</a>';                                        
                                    } else {
                                        echo '<button onclick="return printReceipt()" class="btn btn-block btn-primary">'.lang("print").'</button>';
                                    }
                                    ?>
                                </div>
                                <div class="btn-group" role="group">
                                    <a class="btn btn-block btn-success" href="#" id="email"><?= lang("email"); ?></a>
                                </div>
                                <div class="btn-group" role="group">
                                    <button type="button" class="btn btn-default" data-dismiss="modal"><?= lang('close'); ?></button>
                                </div>
                            </div>
                            <?php } else { ?>
                            <span class="pull-right col-xs-12">
                                <?php
                                if ( ! $Settings->remote_printing) {
                                    echo '<a href="'.site_url('pos/print_receipt/'.$inv->id.'/1').'" id="print" class="btn btn-block btn-primary">'.lang("print").'</a>';
                                    echo '<a href="'.site_url('pos/open_drawer/').'" class="btn btn-block btn-default">'.lang("open_cash_drawer").'</a>';
                                } elseif ($Settings->remote_printing == 1) {
                                    echo '<button onclick="window.print();" class="btn btn-block btn-primary">'.lang("print").'</button>';                                    
                                } elseif ($Settings->remote_printing == 3) {
                                    echo '<a href="'.site_url('pos/pdf_receipt/'.$inv->id.'/0').'" id="print" class="btn btn-block btn-primary">'.lang("print").'</a>';
                                } else {
                                    echo '<button onclick="return printReceipt()" class="btn btn-block btn-primary">'.lang("print").'</button>';
                                    echo '<button onclick="return openCashDrawer()" class="btn btn-block btn-default">'.lang("open_cash_drawer").'</button>';
                                }
                                ?>
                            </span>
                            <?//<span class="pull-left col-xs-12"><a class="btn btn-block btn-success" href="#" id="email"><?= lang("email"); ?></a></span>
                            <?php
                            if($Settings->print_customer_label){ 
                                echo '<a href="'.site_url('pos/label_customer/'.$inv->id).'" id="labelprint" class="btn btn-block btn-primary">'.lang("Print_Delivery_Label_60x40").'</a>'; 
                            }
                            ?>
                            <span class="pull-left col-xs-12"><a class="btn btn-block btn-success" href="<?= site_url('sales'); ?>"><?= lang("back_to_sales"); ?></a></span>							
                            <?php } ?>
                            <div style="clear:both;"></div>
                        </div>
                        <!-- end -->
                    </div>
                </div>
                <!-- start -->
                <?php
                if (!$modal) {
                    ?>
                    <script type="text/javascript">
                        var base_url = '<?=base_url();?>';
                        var site_url = '<?=site_url();?>';
                        var dateformat = '<?=$Settings->dateformat;?>', timeformat = '<?= $Settings->timeformat ?>';
                        <?php unset($Settings->protocol, $Settings->smtp_host, $Settings->smtp_user, $Settings->smtp_pass, $Settings->smtp_port, $Settings->smtp_crypto, $Settings->mailpath, $Settings->timezone, $Settings->setting_id, $Settings->default_email, $Settings->version, $Settings->stripe, $Settings->stripe_secret_key, $Settings->stripe_publishable_key); ?>
                        var Settings = <?= json_encode($Settings); ?>;
                    </script>
                    <script src="<?= $assets ?>plugins/jQuery/jQuery-2.1.4.min.js"></script>
                    <script src="<?= $assets ?>dist/js/libraries.min.js" type="text/javascript"></script>
                    <script src="<?= $assets ?>dist/js/scripts.min.js" type="text/javascript"></script>
                    <?php
                }
                ?>
                <script type="text/javascript">
                    $(document).ready(function () {
                        $('#print').click(function (e) {
                            e.preventDefault();
                            var link = $(this).attr('href');
                            $.get(link);
                            return false;
                        });
                        $('#labelprint').click(function (e) {
                            e.preventDefault();
                            var link = $(this).attr('href');
                            $.get(link);
                            return false;
                        });
                        $('#email').click(function () {
                            bootbox.prompt({
                                title: "<?= lang("email_address"); ?>",
                                inputType: 'email',
                                value: "<?= $customer->email; ?>",
                                callback: function (email) {
                                    if (email != null) {
                                        $.ajax({
                                            type: "post",
                                            url: "<?= site_url('pos/email_receipt') ?>",
                                            data: {<?= $this->security->get_csrf_token_name(); ?>: "<?= $this->security->get_csrf_hash(); ?>", email: email, id: <?= $inv->id; ?>},
                                            dataType: "json",
                                            success: function (data) {
                                                bootbox.alert({message: data.msg, size: 'small'});
                                            },
                                            error: function () {
                                                bootbox.alert({message: '<?= lang('ajax_request_failed'); ?>', size: 'small'});
                                                return false;
                                            }
                                        });
                                    }
                                }
                            });
                            return false;
                        });
                    });
					<?php
					if ($Settings->auto_print == 1) {
						?>
						$(window).load(function () {
                            setTimeout(function() {
								window.print();  
							}, 300);
							return true;      
						});
						<?php
					} else if ($Settings->auto_print == 2) {
                        ?>
						$(window).load(function () {
                            setTimeout(function() {
								window.print();  
                                document.location.href = "pos";
							}, 300);
							return true;      
						});
						<?php
                    }
                    ?>
                    function doPrint() {
                        window.print();            
                        document.location.href = "pos"; 
                    }
                </script>
                <?php /* include FCPATH.'themes'.DIRECTORY_SEPARATOR.$Settings->theme.DIRECTORY_SEPARATOR.'views'.DIRECTORY_SEPARATOR.'pos'.DIRECTORY_SEPARATOR.'remote_printing.php'; */ ?>
                <?php include 'remote_printing.php'; ?>
                <?php
                if ($modal) {
                    ?>
                </div>
            </div>
        </div>
        <?php
    } else {
        ?>
    <!-- end -->
    </body>
    </html>
    <?php
}
?>
