<?php (defined('BASEPATH')) OR exit('No direct script access allowed'); ?>

<div class="modal-dialog">
    <div class="modal-content">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-hidden="true"><i class="fa fa-times"></i></button>
            <button type="button" class="close mr10" onclick="window.print();"><i class="fa fa-print"></i></button>
            <h4 class="modal-title" id="myModalLabel"><?= lang('register_details').' ('.lang('opened_at').': '.$this->tec->hrld($this->session->userdata('register_open_time')).')'; ?></h4>
        </div>
        <div class="modal-body">
            <table width="100%" class="stable">                
                <tr>
                    <td style="border-bottom: 1px solid #EEE;"><h4><?= lang('invoice'); ?>:</h4></td>
                    <td style="text-align:right; border-bottom: 1px solid #EEE;"><h4>
                            <span><?= $totalsales->nbr_sales ? $totalsales->nbr_sales : '0'; ?></span></h4>
                    </td>
                </tr>
                <tr>
                    <td style="border-bottom: 1px solid #EEE;"><h4><?= lang('cash_in_hand'); ?>:</h4></td>
                    <td style="text-align:right; border-bottom: 1px solid #EEE;"><h4>
                            <span><?= $this->tec->formatMoney($this->session->userdata('cash_in_hand')); ?></span></h4>
                    </td>
                </tr>
                <tr>
                    <td style="border-bottom: 1px solid #EEE;"><h4><?= lang('cash_sale'); ?>:</h4></td>
                    <td style="text-align:right; border-bottom: 1px solid #EEE;"><h4>
                            <?//<span><?= $this->tec->formatMoney($cashsales->paid ? $cashsales->paid : '0.00') . ' (' . $this->tec->formatMoney($cashsales->total ? $cashsales->total : '0.00') . ')'; ?></span>
                            <span><?= $this->tec->formatMoney($cashsales->paid ? $cashsales->paid : '0.00'); ?></span>
                        </h4></td>
                </tr>
                <tr>
                    <td style="border-bottom: 1px solid #EEE;"><h4><?= lang('ABA'); ?>:</h4></td>
                    <td style="text-align:right;border-bottom: 1px solid #EEE;"><h4>
                            <span><?= $this->tec->formatMoney($chsales->paid ? $chsales->paid : '0.00'); ?></span>
                        </h4></td>
                </tr>		
                
                <tr>
                    <td style="border-bottom: 1px solid <?= (!isset($Settings->stripe)) ? '#DDD' : '#EEE'; ?>;"><h4><?= lang('ACLEDA'); ?>:</h4></td>
                    <td style="text-align:right;border-bottom: 1px solid <?= (!isset($Settings->stripe)) ? '#DDD' : '#EEE'; ?>;"><h4>
                            <span><?= $this->tec->formatMoney($ccsales->paid ? $ccsales->paid : '0.00'); ?></span>
                        </h4></td>
                </tr>

                <tr>
                    <td style="border-bottom: 1px solid #EEE;"><h4><?= lang('WING'); ?>:</h4></td>
                    <td style="text-align:right;border-bottom: 1px solid #EEE;"><h4>
                            <span><?= $this->tec->formatMoney($gcsales->paid ? $gcsales->paid : '0.00'); ?></span>
                        </h4></td>
                </tr>

                <?php/* if (isset($Settings->stripe)) { ?>
                    <tr>
                        <td style="border-bottom: 1px solid #DDD;"><h4><?= lang('stripe'); ?>:</h4></td>
                        <td style="text-align:right;border-bottom: 1px solid #DDD;"><h4>
                                <span><?= $this->tec->formatMoney($stripesales->paid ? $stripesales->paid : '0.00') . ' (' . $this->tec->formatMoney($stripesales->total ? $stripesales->total : '0.00') . ')'; ?></span>
                            </h4></td>
                    </tr>
                <?php } */?>

                <tr>
                    <td style="border-bottom: 1px solid #008d4c;"><h4><?= lang('other_sale'); ?>:</h4></td>
                    <td style="text-align:right;border-bottom: 1px solid #008d4c;"><h4>
                            <span><?= $this->tec->formatMoney($other_sales->paid ? $other_sales->paid : '0.00'); ?></span>
                        </h4></td>
                </tr>

                <tr>
                    <td width="300px;" style="font-weight:bold;"><h4><?= lang('paid_amount'); ?>:</h4></td>
                    <td width="200px;" style="font-weight:bold;text-align:right;"><h4>
                            <?//<span><?= $this->tec->formatMoney($totalsales->paid ? $totalsales->paid : '0.00') . ' (' . $this->tec->formatMoney($totalsales->total ? $totalsales->total : '0.00') . ')'; ?></span>
                            <span><?= $this->tec->formatMoney($totalsales->paid ? $totalsales->paid : '0.00'); ?></span>
                        </h4></td>
                </tr>

                <tr>
                    <td width="300px;" style="font-weight:bold;"><h4><?= lang('due'); ?>:</h4></td>
                    <td width="200px;" style="font-weight:bold;text-align:right;"><h4>
                            <?//<span><?= $this->tec->formatMoney($totalsales->paid ? $totalsales->paid : '0.00') . ' (' . $this->tec->formatMoney($totalsales->total ? $totalsales->total : '0.00') . ')'; ?></span>
                            <span><?= $this->tec->formatMoney($sales_discount_tax->grand_total - $sales_discount_tax->paid); ?></span>
                        </h4></td>
                </tr>

                <tr style="border-top: 2px solid #000;">
                    <td width="300px;" style="font-weight:bold;"><h4><?= lang('total'); ?>:</h4></td>
                    <td width="200px;" style="font-weight:bold;text-align:right;"><h4>
                            <?//<span><?= $this->tec->formatMoney($totalsales->paid ? $totalsales->paid : '0.00') . ' (' . $this->tec->formatMoney($totalsales->total ? $totalsales->total : '0.00') . ')'; ?></span>
                            <span><?= $this->tec->formatMoney($sales_discount_tax->total ? $sales_discount_tax->total + $sales_discount_tax->product_discount : '0.00'); ?></span>
                        </h4></td>
                </tr>

                <tr>
                    <td width="300px;" style="font-weight:bold;"><h4><?= lang('discount'); ?>:</h4></td>
                    <td width="200px;" style="font-weight:bold;text-align:right;"><h4>
                            <?//<span><?= $this->tec->formatMoney($totalsales->paid ? $totalsales->paid : '0.00') . ' (' . $this->tec->formatMoney($totalsales->total ? $totalsales->total : '0.00') . ')'; ?></span>
                            <span><?= $this->tec->formatMoney($sales_discount_tax->total_discount ? $sales_discount_tax->total_discount : '0.00'); ?></span>
                        </h4></td>
                </tr>

                <tr>
                    <td width="300px;" style="font-weight:bold;"><h4><?= lang('net_total'); ?>:</h4></td>
                    <td width="200px;" style="font-weight:bold;text-align:right;"><h4>
                            <?//<span><?= $this->tec->formatMoney($totalsales->paid ? $totalsales->paid : '0.00') . ' (' . $this->tec->formatMoney($totalsales->total ? $totalsales->total : '0.00') . ')'; ?></span>
                            <span><?= $this->tec->formatMoney($sales_discount_tax->total ? $sales_discount_tax->total - $sales_discount_tax->order_discount : '0.00'); ?></span>
                        </h4></td>
                </tr>

                <tr>
                    <td width="300px;" style="font-weight:bold;"><h4><?= lang('order_tax'); ?>:</h4></td>
                    <td width="200px;" style="font-weight:bold;text-align:right;"><h4>
                            <?//<span><?= $this->tec->formatMoney($totalsales->paid ? $totalsales->paid : '0.00') . ' (' . $this->tec->formatMoney($totalsales->total ? $totalsales->total : '0.00') . ')'; ?></span>
                            <span><?= $this->tec->formatMoney($sales_discount_tax->total_tax ? $sales_discount_tax->total_tax : '0.00'); ?></span>
                        </h4></td>
                </tr>                

                <tr>
                    <td width="300px;" style="font-weight:bold;"><h4><?= lang('grand_total'); ?>:</h4></td>
                    <td width="200px;" style="font-weight:bold;text-align:right;"><h4>
                            <?//<span><?= $this->tec->formatMoney($totalsales->paid ? $totalsales->paid : '0.00') . ' (' . $this->tec->formatMoney($totalsales->total ? $totalsales->total : '0.00') . ')'; ?></span>
                            <span><?= $this->tec->formatMoney($sales_discount_tax->grand_total ? $sales_discount_tax->grand_total : '0.00'); ?></span>
                        </h4></td>
                </tr>

                <tr style="border-top: 2px solid #000;">
                    <td width="300px;" style="font-weight:bold;"><h4><?= lang('cash'); ?>:</h4></td>
                    <td width="200px;" style="font-weight:bold;text-align:right;"><h4>
                            <span><?= $cashsales->paid ? $this->tec->formatMoney($cashsales->paid + ($this->session->userdata('cash_in_hand'))) : $this->tec->formatMoney($this->session->userdata('cash_in_hand')); ?></span>
                        </h4></td>
                </tr>
                
                <tr>
                    <td width="300px;" style="font-weight:bold;"><h4><?= lang('expenses'); ?>:</h4></td>
                    <td width="200px;" style="font-weight:bold;text-align:right;"><h4>
                            <span><?= $this->tec->formatMoney($expenses->total ? $expenses->total : '0.00'); ?></span>
                        </h4></td>
                </tr>

                <tr>
                    <td width="300px;" style="font-weight:bold;"><h4><strong><?= lang('total_cash'); ?></strong>:</h4>
                    </td>
                    <td style="text-align:right;"><h4>
                            <span><strong><?= $cashsales->paid ? $this->tec->formatMoney($cashsales->paid + ($this->session->userdata('cash_in_hand')) - ($expenses->total ? $expenses->total : 0.00)) : $this->tec->formatMoney($this->session->userdata('cash_in_hand') - ($expenses->total ? $expenses->total : 0.00)); ?></strong></span>
                        </h4></td>
                </tr>
            </table>
        </div>
    </div>

</div>
<style type="text/css" media="all">
    @page {
        margin: 2px 5px 2px 2px;
        width: 78mm;
    }
    @media print {
        .no-print { display: none; }
        .modal-dialog, .modal-content{ max-width: 390px; min-width: 230px; margin: 0; margin-left: -2px;}
        tr {font-size: 14px;}
        hr {margin-top: 5px; margin-bottom:5px;}
        table.table-bordered tr, table.table-bordered td, table.table-bordered th {border: 1px solid #000!important;}
        h4 {font-size: 20px!important; margin: 8px;}
        body { 
							color: #000; 
							font-family: "Battambang", "Khmer OS Battambang";
							font-size: 14px;
							line-height: 1;
							margin: 0px;
						}						
    }
</style>
