<?php (defined('BASEPATH')) OR exit('No direct script access allowed'); ?>

<section class="content">
    <div class="row">
        <div class="col-xs-12">
            <div class="box box-primary">
                <div class="box-header">
                    <h3 class="box-title"><?= lang('enter_info'); ?></h3>
                </div>
                <div class="box-body">
                    <div class="col-lg-12">

                        <?php echo form_open_multipart("exchanges/add", 'class="validation"'); ?>
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <?= lang('date', 'date'); ?>
                                    <?= form_input('date', set_value('date', date('Y-m-d H:i')), 'class="form-control tip datetimepicker" id="date"  required="required"'); ?>
                                </div>
                                <div class="form-group">
                                    <?= lang('sell_rate', 'sell_rate'); ?>
                                    <?= form_input('sell_rate', set_value('sell_rate'), 'class="form-control tip" id="sell_rate"  required="required"'); ?>
                                </div>   
                                <div class="form-group">
                                    <?= lang('buy_rate', 'buy_rate'); ?>
                                    <?= form_input('buy_rate', set_value('buy_rate'), 'class="form-control tip" id="buy_rate"  required="required"'); ?>
                                </div>  
                                <div class="form-group">
                                    <?= lang('type', 'type'); ?>
                                    <?php $tm = array('sell' => lang('sell'), 'buy' => lang('buy')); ?>
                                    <?= form_dropdown('type', $tm, set_value('type'), 'class="form-control tip select2" id="type"  required="required" style="width:100%;"'); ?>
                                </div>   
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <?= lang('amount_to_change', 'amount_to_change'); ?>
                                    <?= form_input('amount_to_change', set_value('amount_to_change'), 'class="form-control tip" id="amount_to_change"  required="required"'); ?>
                                </div>   
                                <div class="form-group">
                                    <?= lang('amount_changed', 'amount_changed'); ?>
                                    <?= form_input('amount_changed', set_value('amount_changed'), 'class="form-control tip" id="amount_changed"  required="required"'); ?>
                                </div>                              
                                <div class="form-group">
                                    <?= lang('amount_received', 'amount_received'); ?>
                                    <?= form_input('amount_received', set_value('amount_received'), 'class="form-control tip" id="amount_received"  required="required"'); ?>
                                </div>                                                                
                                <div class="form-group">
                                    <?= lang('changes', 'changes'); ?>
                                    <?= form_input('changes', set_value('changes'), 'class="form-control tip" id="changes"  required="required" readonly'); ?>
                                </div>
                            </div>
                            <div class="col-md-4">
                                
                                <div class="form-group">
                                    <?= lang('symbol_to_change', 'symbol_to_change'); ?>
                                    <?php $tm = array('USD' => lang('USD'), 'KHR' => lang('KHR')); ?>
                                    <?= form_dropdown('symbol_to_change', $tm, set_value('symbol_to_change'), 'class="form-control tip select2" id="symbol_changed"  required="required" style="width:100%;"'); ?>
                                </div>                                
                                <div class="form-group">
                                    <?= lang('symbol_changed', 'symbol_changed'); ?>
                                    <?php $tm = array('KHR' => lang('KHR'), 'USD' => lang('USD')); ?>
                                    <?= form_dropdown('symbol_changed', $tm, set_value('symbol_changed'), 'class="form-control tip select2" id="symbol_changed"  required="required" style="width:100%;"'); ?>
                                </div>
                            </div>
                        </div>                      

                        
                        <div class="form-group">
                            <?= form_submit('add_exchanges', lang('add_exchanges'), 'class="btn btn-primary"'); ?>
                        </div>

                        <?php echo form_close();?>
                    </div>
                    <div class="clearfix"></div>
                </div>
            </div>
        </div>
    </div>
</section>
<script src="<?= $assets ?>dist/js/exchanges.min.js" type="text/javascript"></script>
<script src="<?= $assets ?>plugins/bootstrap-datetimepicker/js/moment.min.js" type="text/javascript"></script>
<script src="<?= $assets ?>plugins/bootstrap-datetimepicker/js/bootstrap-datetimepicker.min.js" type="text/javascript"></script>
<script type="text/javascript">
    $(function () {
        $('.datetimepicker').datetimepicker({
            format: 'YYYY-MM-DD HH:mm:ss'
        });
    });
</script>
