<?php (defined('BASEPATH')) OR exit('No direct script access allowed'); ?>

<div class="modal-dialog">
    <div class="modal-content">
        <div class="modal-header modal-primary">
            <button type="button" class="close" data-dismiss="modal" aria-hidden="true"><i class="fa fa-times"></i></button>
            <button type="button" class="close mr10" onclick="window.print();"><i class="fa fa-print"></i></button>
            <h4 class="modal-title" id="myModalLabel">
                <?= lang('adjustment').' # '.$adjustment->id; ?>
            </h4>
        </div>
        <div class="modal-body">
            <div class="row">
                <div class="col-md-12">
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <tbody>
                                <tr>
                                    <td class="col-xs-2"><?= lang('date'); ?></td>
                                    <td class="col-xs-10"><?= $this->tec->hrld($adjustment->date); ?></td>
                                </tr>
                                <tr>
                                    <td class="col-xs-2"><?= lang('reference'); ?></td>
                                    <td class="col-xs-10"><?= $adjustment->reference; ?></td>
                                </tr>
                                <?php
                                if ($adjustment->attachment) {
                                    ?>
                                    <tr>
                                        <td class="col-xs-2"><?= lang('attachment'); ?></td>
                                        <td class="col-xs-10"><a href="<?=base_url('uploads/'.$adjustment->attachment);?>"><?= $adjustment->attachment; ?></a></td>
                                    </tr>
                                    <?php
                                }
                                if ($adjustment->note) {
                                    ?>
                                    <tr>
                                        <td class="col-xs-2"><?= lang('note'); ?></td>
                                        <td class="col-xs-10"><?= $adjustment->note; ?></td>
                                    </tr>
                                    <?php
                                }
                                ?>
                            </tbody>
                        </table>
                        <div class="table-responsive">
                            <table class="table table-striped table-bordered" style="margin-bottom:0;">
                                <thead>
                                    <tr class="active">
                                        <th><?= lang('product'); ?></th>
                                        <th class="col-xs-2"><?= lang('quantity'); ?></th>
                                        <? if ($Settings->show_unit) { ?>
                                        <th class="col-xs-2"><?= lang('unit'); ?></th>
                                        <? } ?>
                                        <th class="col-xs-2"><?= lang('type'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    if ($items) {
                                        foreach ($items as $item) {
                                            $cnv_type = ($item->type == 'add') ? lang('add') : lang('deduct');
                                            echo '<tr>';
                                            echo '<td>'.$item->product_name.' ('.$item->product_code.')</td>';
                                            echo '<td class="text-center">'.$this->tec->formatQuantity($item->quantity).'</td>';
                                            if ($Settings->show_unit) {
                                            echo '<td class="text-center">'.$item->product_unit.'</td>';
                                            }
                                            echo '<td class="text-center">'.$cnv_type.'</td>';
                                            echo '</tr>';
                                        }
                                    }
                                    ?>
                                </tbody>                                
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
