<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Pos_model extends CI_Model
{

    public function __construct() {
        parent::__construct();
    }

    public function getProductNames($term, $limit = 10) {
        $store_id = $this->session->userdata('store_id');
        $this->db->select("{$this->db->dbprefix('products')}.*, COALESCE(psq.quantity, 0) as quantity, COALESCE(psq.price, 0) as store_price, COALESCE(psq.price_wholesale, 0) as store_price_wholesale, COALESCE(psq.price_vip, 0) as store_price_vip")
        ->join("( SELECT * from {$this->db->dbprefix('product_store_qty')} WHERE store_id = {$store_id}) psq", 'products.id=psq.product_id', 'left');
        if ($this->db->dbdriver == 'sqlite3') {
            $this->db->where("(name LIKE '%{$term}%' OR code LIKE '%{$term}%' OR  (name || ' (' || code || ')') LIKE '%{$term}%' OR second_name LIKE '%{$term}%')");
        } else {
            $this->db->where("(name LIKE '%{$term}%' OR code LIKE '%{$term}%' OR  concat(name, ' (', code, ')') LIKE '%{$term}%' OR second_name LIKE '%{$term}%')");
        }
        $this->db->where('ingredient',0);
        $this->db->group_by('products.id')->limit($limit);
        $q = $this->db->get('products');
        if ($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }

    public function getProductNamesByStore($term, $limit = 10) {
        $store_id = $this->session->userdata('store_id');
        $this->db->select("{$this->db->dbprefix('products')}.*, COALESCE(psq.quantity, 0) as quantity, COALESCE(psq.price, 0) as store_price, COALESCE(psq.price_wholesale, 0) as store_price_wholesale")
        ->join("( SELECT * from {$this->db->dbprefix('product_store_qty')} WHERE store_id = {$store_id} AND price>0) psq", 'products.id=psq.product_id', 'right');
        if ($this->db->dbdriver == 'sqlite3') {
            $this->db->where("(name LIKE '%{$term}%' OR code LIKE '%{$term}%' OR  (name || ' (' || code || ')') LIKE '%{$term}%' OR second_name LIKE '%{$term}%')");
        } else {
            $this->db->where("(name LIKE '%{$term}%' OR code LIKE '%{$term}%' OR  concat(name, ' (', code, ')') LIKE '%{$term}%' OR second_name LIKE '%{$term}%')");
        }
        $this->db->where('ingredient',0);
        $this->db->group_by('products.id')->limit($limit);
        $q = $this->db->get('products');
        if ($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }

    public function getTodaySales() {
        $date = date('Y-m-d 00:00:00');
        $this->db->select('SUM( COALESCE( grand_total, 0 ) ) AS total, SUM( COALESCE( amount, 0 ) ) AS paid, COUNT(sale_id) as nbr_sales', FALSE)
            ->join('sales', 'sales.id=payments.sale_id', 'left')
            ->where('payments.date >', $date);

        $q = $this->db->get('payments');
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return false;
    }

    public function getTodaySalesDiscountTax() {
        $date = date('Y-m-d 00:00:00');
        $this->db->select('SUM( COALESCE( order_tax, 0 ) ) AS order_tax, SUM( COALESCE( product_tax, 0 ) ) AS product_tax, SUM( COALESCE( total_tax, 0 ) ) AS total_tax, SUM( COALESCE(total, 0 ) ) AS total, SUM( COALESCE(grand_total, 0 ) ) AS grand_total, SUM( COALESCE(paid, 0 ) ) AS paid,  SUM( COALESCE( total_discount, 0 ) ) AS total_discount, SUM( COALESCE( product_discount, 0 ) ) AS product_discount,  SUM( COALESCE( order_discount, 0 ) ) AS order_discount', FALSE)
            ->where('date >', $date);

        $q = $this->db->get('sales');
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return false;
    }

    public function getTodaySalesDue() {
        $date = date('Y-m-d 00:00:00');
        $this->db->select('SUM(grand_total) AS totalsales, SUM(grand_total - paid) AS due, COUNT(id) as nbr_sales, SUM(total) as total, SUM(total_discount) as total_discount, SUM(total_tax) as total_tax, SUM( COALESCE( order_tax, 0 ) ) AS order_tax, SUM( COALESCE( product_tax, 0 ) ) AS product_tax, SUM( COALESCE( product_discount, 0 ) ) AS product_discount,  SUM( COALESCE( order_discount, 0 ) ) AS order_discount, SUM( COALESCE(paid, 0 ) ) AS paid', FALSE)
            ->where('date >', $date);

        $q = $this->db->get('sales');
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return false;
    }

    public function getTodayCCSales() { // as ACLEDA
        $date = date('Y-m-d 00:00:00');
        $this->db->select('COUNT(' . $this->db->dbprefix('payments') . '.id) as total_cc_slips, SUM( COALESCE( grand_total, 0 ) ) AS total, SUM( COALESCE( amount, 0 ) ) AS paid', FALSE)
            ->join('sales', 'sales.id=payments.sale_id', 'left')
            ->where('payments.date >', $date)->where("{$this->db->dbprefix('payments')}.paid_by", 'ACLEDA');

        $q = $this->db->get('payments');
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return false;
    }

    public function getTodayCashSales() {
        $date = date('Y-m-d 00:00:00');
        $this->db->select('SUM( COALESCE( grand_total, 0 ) ) AS total, SUM( COALESCE( amount, 0 ) ) AS paid', FALSE)
            ->join('sales', 'sales.id=payments.sale_id', 'left')
            ->where('payments.date >', $date)->where("{$this->db->dbprefix('payments')}.paid_by", 'cash');

        $q = $this->db->get('payments');
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return false;
    }

    public function getTodayRefunds() {
        $date = date('Y-m-d 00:00:00');
        $this->db->select('SUM( COALESCE( grand_total, 0 ) ) AS total, SUM( COALESCE( amount, 0 ) ) AS returned', FALSE)
            ->join('return_sales', 'return_sales.id=payments.return_id', 'left')
            ->where('type', 'returned')->where('payments.date >', $date);

        $q = $this->db->get('payments');
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return false;
    }

    public function getTodayExpenses() {
        $date = date('Y-m-d 00:00:00');
        $this->db->select('SUM( COALESCE( amount, 0 ) ) AS total', FALSE)
            ->where('date >', $date);

        $q = $this->db->get('expenses');
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return false;
    }

    public function getTodayCost() {
        $date = date('Y-m-d 00:00:00');
        $this->db->select('SUM(COALESCE(total_cost,0)) AS total_cost', FALSE)
            ->where('date >', $date);

        $q = $this->db->get('sales');
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return false;
    }

    public function getTodayCashRefunds() {
        $date = date('Y-m-d 00:00:00');
        $this->db->select('SUM( COALESCE( grand_total, 0 ) ) AS total, SUM( COALESCE( amount, 0 ) ) AS returned', FALSE)
            ->join('return_sales', 'return_sales.id=payments.return_id', 'left')
            ->where('type', 'returned')->where('payments.date >', $date)->where("{$this->db->dbprefix('payments')}.paid_by", 'cash');

        $q = $this->db->get('payments');
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return false;
    }

    public function getTodayChSales() { // as ABA
        $date = date('Y-m-d 00:00:00');
        $this->db->select('COUNT(' . $this->db->dbprefix('payments') . '.id) as total_cheques, SUM( COALESCE( grand_total, 0 ) ) AS total, SUM( COALESCE( amount, 0 ) ) AS paid', FALSE)
            ->join('sales', 'sales.id=payments.sale_id', 'left')
            ->where('payments.date >', $date)
            ->group_start()->where("{$this->db->dbprefix('payments')}.paid_by", 'Cheque')->or_where("{$this->db->dbprefix('payments')}.paid_by", 'ABA')->group_end();

        $q = $this->db->get('payments');
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return false;
    }

    public function getTodayOtherSales() {
        $date = date('Y-m-d 00:00:00');
        $this->db->select('COUNT(' . $this->db->dbprefix('payments') . '.id) as total_cheques, SUM( COALESCE( grand_total, 0 ) ) AS total, SUM( COALESCE( amount, 0 ) ) AS paid', FALSE)
            ->join('sales', 'sales.id=payments.sale_id', 'left')
            ->where('payments.date >', $date)->where("{$this->db->dbprefix('payments')}.paid_by", 'other');

        $q = $this->db->get('payments');
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return false;
    }

    public function getTodayGCSales() { // as WING
        $date = date('Y-m-d 00:00:00');
        $this->db->select('COUNT(' . $this->db->dbprefix('payments') . '.id) as total_cheques, SUM( COALESCE( grand_total, 0 ) ) AS total, SUM( COALESCE( amount, 0 ) ) AS paid', FALSE)
            ->join('sales', 'sales.id=payments.sale_id', 'left')
            ->where('payments.date >', $date)->where("{$this->db->dbprefix('payments')}.paid_by", 'WING');

        $q = $this->db->get('payments');
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return false;
    }

    public function getTodayStripeSales() {
        $date = date('Y-m-d 00:00:00');
        $this->db->select('COUNT(' . $this->db->dbprefix('payments') . '.id) as total_cheques, SUM( COALESCE( grand_total, 0 ) ) AS total, SUM( COALESCE( amount, 0 ) ) AS paid', FALSE)
            ->join('sales', 'sales.id=payments.sale_id', 'left')
            ->where('payments.date >', $date)->where("{$this->db->dbprefix('payments')}.paid_by", 'stripe');

        $q = $this->db->get('payments');
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return false;
    }

    public function getRegisterSales($date = NULL, $user_id = NULL) {
        if (!$date) {
            $date = $this->session->userdata('register_open_time');
        }
        if (!$user_id) {
            $user_id = $this->session->userdata('user_id');
        }
        $this->db->select('SUM( COALESCE( grand_total, 0 ) ) AS total, SUM( COALESCE( amount, 0 ) ) AS paid, COUNT(sale_id) as nbr_sales', FALSE)
            ->join('sales', 'sales.id=payments.sale_id', 'left')
            ->where('payments.date >', $date);
        $this->db->where('payments.created_by', $user_id);

        $q = $this->db->get('payments');
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return false;
    }

    public function getRegisterSaleItems_category($date = NULL, $user_id = NULL) {
        if (!$date) {
            $date = $this->session->userdata('register_open_time');
        }
        if (!$user_id) {
            $user_id = $this->session->userdata('user_id');
        }
        $j = "(SELECT id, code, name, tax_method from {$this->db->dbprefix('products')}) P";
        $this->db->select($this->db->dbprefix('categories') . '.name as category_name, ' . $this->db->dbprefix('sale_items') . '.*, SUM(' . $this->db->dbprefix('sale_items') . '.quantity) AS sold, (SUM(((1-(' . $this->db->dbprefix('sales') . '.order_discount/ ' . $this->db->dbprefix('sales') . '.total)) * ' . $this->db->dbprefix('sale_items') . '.subtotal))) AS mysubtotal, SUM(' . $this->db->dbprefix('sale_items') . '.item_discount) AS mydiscount')
        ->join('sales', 'sales.id=sale_items.sale_id', 'left')
        ->join('products', 'products.id=sale_items.product_id', 'left')
        ->join('categories', 'categories.id=products.category_id', 'left')
        ->where('sales.date >', $date)
        ->group_by('products.category_id')
        ->order_by('products.category_id','asc');
        $q = $this->db->get_where('sale_items', array('sales.created_by' => $user_id));
        if($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }

    public function getRegisterSaleItems($date = NULL, $user_id = NULL) {
        if (!$date) {
            $date = $this->session->userdata('register_open_time');
        }
        if (!$user_id) {
            $user_id = $this->session->userdata('user_id');
        }
        $j = "(SELECT id, code, name, tax_method from {$this->db->dbprefix('products')}) P";
        $this->db->select($this->db->dbprefix('sale_items') . '.*, SUM(' . $this->db->dbprefix('sale_items') . '.quantity) AS sold, (SUM(((1-(' . $this->db->dbprefix('sales') . '.order_discount/ ' . $this->db->dbprefix('sales') . '.total)) * ' . $this->db->dbprefix('sale_items') . '.subtotal))) AS mysubtotal, SUM(' . $this->db->dbprefix('sale_items') . '.item_discount) AS mydiscount')
        ->join('sales', 'sales.id=sale_items.sale_id', 'left')
        ->join('products', 'products.id=sale_items.product_id', 'left')
        ->where('sales.date >', $date)
        ->group_by('sale_items.product_id')
        ->order_by('products.category_id','asc')
        ->order_by('sale_items.product_name','desc');
        $q = $this->db->get_where('sale_items', array('sales.created_by' => $user_id));
        if($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }

    public function getTodaySaleItems() {
        $date = date('Y-m-d 00:00:00');
        $j = "(SELECT id, code, name, tax_method from {$this->db->dbprefix('products')}) P";
        $this->db->select($this->db->dbprefix('sale_items') . '.*, SUM(' . $this->db->dbprefix('sale_items') . '.quantity) AS sold, (SUM(((1-(' . $this->db->dbprefix('sales') . '.order_discount/ ' . $this->db->dbprefix('sales') . '.total)) * ' . $this->db->dbprefix('sale_items') . '.subtotal))) AS mysubtotal, SUM(' . $this->db->dbprefix('sale_items') . '.item_discount) AS mydiscount')
        ->join('sales', 'sales.id=sale_items.sale_id', 'left')
        ->join('products', 'products.id=sale_items.product_id', 'left')
        ->where('sales.date >', $date)
        ->group_by('sale_items.product_id')
        ->order_by('products.category_id','asc')
        ->order_by('sale_items.product_name','desc');
        $q = $this->db->get('sale_items');
        if($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }

    public function getRegisterCCSales($date = NULL, $user_id = NULL) { // as ACLEDA
        if (!$date) {
            $date = $this->session->userdata('register_open_time');
        }
        if (!$user_id) {
            $user_id = $this->session->userdata('user_id');
        }
        $this->db->select('COUNT(' . $this->db->dbprefix('payments') . '.id) as total_cc_slips, SUM( COALESCE( grand_total, 0 ) ) AS total, SUM( COALESCE( amount, 0 ) ) AS paid', FALSE)
            ->join('sales', 'sales.id=payments.sale_id', 'left')
            ->where('payments.date >', $date)->where("{$this->db->dbprefix('payments')}.paid_by", 'ACLEDA');
        $this->db->where('payments.created_by', $user_id);

        $q = $this->db->get('payments');
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return false;
    }

    public function getRegisterCashSales($date = NULL, $user_id = NULL) {
        if (!$date) {
            $date = $this->session->userdata('register_open_time');
        }
        if (!$user_id) {
            $user_id = $this->session->userdata('user_id');
        }
        $this->db->select('SUM( COALESCE( grand_total, 0 ) ) AS total, SUM( COALESCE( amount, 0 ) ) AS paid', FALSE)
            ->join('sales', 'sales.id=payments.sale_id', 'left')
            ->where('payments.date >', $date)->where("{$this->db->dbprefix('payments')}.paid_by", 'cash');
        $this->db->where('payments.created_by', $user_id);

        $q = $this->db->get('payments');
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return false;
    }

    public function getRegisterRefunds($date = NULL, $user_id = NULL) {
        if (!$date) {
            $date = $this->session->userdata('register_open_time');
        }
        if (!$user_id) {
            $user_id = $this->session->userdata('user_id');
        }
        $this->db->select('SUM( COALESCE( grand_total, 0 ) ) AS total, SUM( COALESCE( amount, 0 ) ) AS returned', FALSE)
            ->join('return_sales', 'return_sales.id=payments.return_id', 'left')
            ->where('type', 'returned')->where('payments.date >', $date);
        $this->db->where('payments.created_by', $user_id);

        $q = $this->db->get('payments');
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return false;
    }

    public function getRegisterCashRefunds($date = NULL, $user_id = NULL) {
        if (!$date) {
            $date = $this->session->userdata('register_open_time');
        }
        if (!$user_id) {
            $user_id = $this->session->userdata('user_id');
        }
        $this->db->select('SUM( COALESCE( grand_total, 0 ) ) AS total, SUM( COALESCE( amount, 0 ) ) AS returned', FALSE)
            ->join('return_sales', 'return_sales.id=payments.return_id', 'left')
            ->where('type', 'returned')->where('payments.date >', $date)->where("{$this->db->dbprefix('payments')}.paid_by", 'cash');
        $this->db->where('payments.created_by', $user_id);

        $q = $this->db->get('payments');
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return false;
    }

    public function getRegisterExpenses($date = NULL, $user_id = NULL) {
        if (!$date) {
            $date = $this->session->userdata('register_open_time');
        }
        if (!$user_id) {
            $user_id = $this->session->userdata('user_id');
        }
        $this->db->select('SUM( COALESCE( amount, 0 ) ) AS total', FALSE)
            ->where('date >=', $date);
        $this->db->where('created_by', $user_id);

        $q = $this->db->get('expenses');
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return false;
    }

    public function getRegisterChSales($date = NULL, $user_id = NULL) { // as ABA
        if (!$date) {
            $date = $this->session->userdata('register_open_time');
        }
        if (!$user_id) {
            $user_id = $this->session->userdata('user_id');
        }
        $this->db->select('COUNT(' . $this->db->dbprefix('payments') . '.id) as total_cheques, SUM( COALESCE( grand_total, 0 ) ) AS total, SUM( COALESCE( amount, 0 ) ) AS paid', FALSE)
            ->join('sales', 'sales.id=payments.sale_id', 'left')
            ->where('payments.date >', $date)
            ->group_start()->where("{$this->db->dbprefix('payments')}.paid_by", 'Cheque')->or_where("{$this->db->dbprefix('payments')}.paid_by", 'ABA')->group_end();
        $this->db->where('payments.created_by', $user_id);

        $q = $this->db->get('payments');
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return false;
    }

    public function getRegisterOtherSales($date = NULL, $user_id = NULL) {
        if (!$date) {
            $date = $this->session->userdata('register_open_time');
        }
        if (!$user_id) {
            $user_id = $this->session->userdata('user_id');
        }
        $this->db->select('COUNT(' . $this->db->dbprefix('payments') . '.id) as total_cheques, SUM( COALESCE( grand_total, 0 ) ) AS total, SUM( COALESCE( amount, 0 ) ) AS paid', FALSE)
            ->join('sales', 'sales.id=payments.sale_id', 'left')
            ->where('payments.date >', $date)->where("{$this->db->dbprefix('payments')}.paid_by", 'other');
        $this->db->where('payments.created_by', $user_id);

        $q = $this->db->get('payments');
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return false;
    }

    public function getRegisterGCSales($date = NULL, $user_id = NULL) { // as WING
        if (!$date) {
            $date = $this->session->userdata('register_open_time');
        }
        if (!$user_id) {
            $user_id = $this->session->userdata('user_id');
        }
        $this->db->select('COUNT(' . $this->db->dbprefix('payments') . '.id) as total_cheques, SUM( COALESCE( grand_total, 0 ) ) AS total, SUM( COALESCE( amount, 0 ) ) AS paid', FALSE)
            ->join('sales', 'sales.id=payments.sale_id', 'left')
            ->where('payments.date >', $date)->where("{$this->db->dbprefix('payments')}.paid_by", 'WING');
        $this->db->where('payments.created_by', $user_id);

        $q = $this->db->get('payments');
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return false;
    }

    public function getRegisterStripeSales($date = NULL, $user_id = NULL) {
        if (!$date) {
            $date = $this->session->userdata('register_open_time');
        }
        if (!$user_id) {
            $user_id = $this->session->userdata('user_id');
        }
        $this->db->select('COUNT(' . $this->db->dbprefix('payments') . '.id) as total_cheques, SUM( COALESCE( grand_total, 0 ) ) AS total, SUM( COALESCE( amount, 0 ) ) AS paid', FALSE)
            ->join('sales', 'sales.id=payments.sale_id', 'left')
            ->where('payments.date >', $date)->where("{$this->db->dbprefix('payments')}.paid_by", 'stripe');
        $this->db->where('payments.created_by', $user_id);

        $q = $this->db->get('payments');
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return false;
    }

    public function products_count($category_id) {
        if ($category_id) {
           $this->db->where('category_id', $category_id);
        }
        return $this->db->count_all_results('products');
    }

    public function fetch_products($category_id, $limit, $start, $type) {
        $this->db->limit($limit, $start);
        if ($category_id) {
           $this->db->where('category_id', $category_id);
        }
        if ($type <> 'all') {
            $this->db->where('type', $type);
        }
        $this->db->where('ingredient', 0);
        $this->db->order_by("category_id", "asc");
        $this->db->order_by("code", "asc");
        $query = $this->db->get("products");

        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return false;
    }

    public function fetch_products_notoversell($category_id, $limit, $start, $type) {
        $this->db->limit($limit, $start);
        if ($category_id) {
           $this->db->where('category_id', $category_id);
        }
        if ($type <> 'all') {
            $this->db->where('type', $type);
        }
        $this->db->where('ingredient', 0);
        $this->db->order_by("code", "asc");
        $this->db->select("products.*")
            ->join('product_store_qty','product_store_qty.product_id=products.id')
            ->where('product_store_qty.quantity>0');

        $query = $this->db->get("products");    
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return false;
    }

    public function registerData($user_id = NULL) {
        if (!$user_id) {
            $user_id = $this->session->userdata('user_id');
        }
        $q = $this->db->get_where('registers', array('user_id' => $user_id, 'status' => 'open'), 1);
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    }

    public function openRegister($data) {
        if ($this->db->insert('registers', $data)) {
            return true;
        }
        return FALSE;
    }

    public function getOpenRegisters() {
        $this->db->select("date, user_id, cash_in_hand, CONCAT(" . $this->db->dbprefix('users') . ".first_name, ' ', " . $this->db->dbprefix('users') . ".last_name, ' - ', " . $this->db->dbprefix('users') . ".email) as user", FALSE)
            ->join('users', 'users.id=pos_register.user_id', 'left');
        $q = $this->db->get_where('registers', array('status' => 'open'));
        if ($q->num_rows() > 0) {
            foreach ($q->result() as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;

    }

    public function closeRegister($rid, $user_id, $data) {
        if (!$rid) {
            $rid = $this->session->userdata('register_id');
        }
        if (!$user_id) {
            $user_id = $this->session->userdata('user_id');
        }
        if ($data['transfer_opened_bills'] == -1) {
            $this->db->delete('suspended_sales', array('created_by' => $user_id));
        } elseif ($data['transfer_opened_bills'] != 0) {
            $this->db->update('suspended_sales', array('created_by' => $data['transfer_opened_bills']), array('created_by' => $user_id));
        }
        if ($this->db->update('registers', $data, array('id' => $rid, 'user_id' => $user_id))) {
            return true;
        }
        return FALSE;
    }

    public function getCustomerByID($id) {
        $q = $this->db->get_where('customers', array('id' => $id), 1);
          if( $q->num_rows() > 0 ) {
            return $q->row();
          }
          return FALSE;
    }

    public function getProductOptionByID($id) {
        $q = $this->db->get_where('product_options', array('id' => $id), 1);
          if( $q->num_rows() > 0 ) {
            return $q->row();
          }
          return FALSE;
    }

    public function getProductOptionByGroup($group,$type) {
        $this->db->order_by('code');
        if ($group == '0') {
            $q = $this->db->get_where('product_options', array('type' => $type));
        } else {
            $q = $this->db->get_where('product_options', array('group_id' => $group,'type' => $type));
        }
        if ($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }

    public function getProductByCode($code) {
        $jpsq = "( SELECT product_id, quantity, price, price_wholesale, price_vip from {$this->db->dbprefix('product_store_qty')} WHERE store_id = {$this->session->userdata('store_id')} ) AS PSQ";
        $this->db->select("{$this->db->dbprefix('products')}.*, COALESCE(PSQ.quantity, 0) as quantity, COALESCE(PSQ.price, {$this->db->dbprefix('products')}.price) as store_price, COALESCE(PSQ.price_wholesale, {$this->db->dbprefix('products')}.price_wholesale) as store_price_wholesale, COALESCE(PSQ.price_vip, {$this->db->dbprefix('products')}.price_vip) as store_price_vip", FALSE)
        ->join($jpsq, 'PSQ.product_id=products.id', 'left');
        $q = $this->db->get_where('products', array('code' => $code), 1);
          if( $q->num_rows() > 0 )
          {
            return $q->row();
          }
          return FALSE;
    }

    public function addSale($data, $items, $payment = array(), $did = NULL) {
        if($did) {
            $q = $this->db->get_where('suspended_sales', array('id' => $did),1);
            if($q->num_rows() > 0){
                $data['date_in'] = $q->row()->date_in;
            }
        }
        //Set Inv_Number
        $inv_number = $this->getStoreInvNumber($data['store_id']);
        if(!($data['inv_number'])){            
            $data['inv_number'] = $inv_number; 
        }
        if($this->db->insert('sales', $data)) {
            $sale_id = $this->db->insert_id();
            if($this->Settings->multistore_quantity) {$data['store_id']=1;}
            foreach ($items as $item) {
                $item['sale_id'] = $sale_id;
                if($this->db->insert('sale_items', $item)) {
                    if ($item['product_id'] > 0 && $product = $this->site->getProductByID($item['product_id'],$data['store_id'])) {
                        if ($product->type == 'standard' || $product->type == 'other') { 
                            if ($this->getStoreQuantity($item['product_id'], $data['store_id'])) {
                                $this->db->update('product_store_qty', array('quantity' => ($product->quantity-($item['quantity']*($item['length']>0?$item['length']:1)))), array('product_id' => $product->id, 'store_id' => $data['store_id']));
                            } else {
                                $store_quantity = array(
                                    'product_id' => $item['product_id'],
                                    'store_id' => $data['store_id'],
                                    'quantity' => $product->quantity-($item['quantity']*($item['length']>0?$item['length']:1)),
                                    'price' => $product->price,
                                    'price_wholesale' => $product->price_wholesale,
                                    'price_vip' => $product->price_vip                    
                                    );
                                $this->db->insert('product_store_qty', $store_quantity);
                            }
                        } elseif ($product->type == 'combo') {
                            $combo_items = $this->getComboItemsByPID($product->id);
                            foreach ($combo_items as $combo_item) {
                                $cpr = $this->site->getProductByID($combo_item->id);
                                if($cpr->type == 'standard' || $cpr->type == 'other') {
                                    $qty = $combo_item->qty * $item['quantity'] * ($item['length']>0?$item['length']:1);
                                    if ($this->getStoreQuantity($cpr->id, $data['store_id'])) {
                                        $this->db->update('product_store_qty', array('quantity' => ($cpr->quantity-$qty)), array('product_id' => $cpr->id, 'store_id' => $data['store_id']));
                                    } else {
                                        $store_quantity = array(
                                            'product_id' => $cpr->id,
                                            'store_id' => $data['store_id'],
                                            'quantity' => $cpr->quantity-$qty,
                                            'price' => $cpr->price,
                                            'price_wholesale' => $cpr->price_wholesale,
                                            'price_vip' => $cpr->price_vip                    
                                            );
                                        $this->db->insert('product_store_qty', $store_quantity);
                                    }
                                }
                            }
                        }
                    }
                }
            }

            //Update Store Inv_Number
            $this->db->update('stores',array('inv_number'=>$inv_number),array('id'=>$data['store_id']));

            if($did) {
                $this->db->delete('suspended_sales', array('id' => $did));
                $this->db->delete('suspended_items', array('suspend_id' => $did));
            }
            $msg = array();
            if(! empty($payment)) {
                if ($payment['paid_by'] == 'stripe') {
                    $card_info = array("number" => $payment['cc_no'], "exp_month" => $payment['cc_month'], "exp_year" => $payment['cc_year'], "cvc" => $payment['cc_cvv2'], 'type' => $payment['cc_type']);
                    $result = $this->stripe($payment['amount'], $card_info);
                    if (!isset($result['error']) && !empty($result['transaction_id'])) {
                        $payment['transaction_id'] = $result['transaction_id'];
                        $payment['date'] = $result['created_at'];
                        $payment['amount'] = $result['amount'];
                        $payment['currency'] = $result['currency'];
                        unset($payment['cc_cvv2']);
                        $payment['sale_id'] = $sale_id;
                        $this->db->insert('payments', $payment);
                    } else {
                        $this->db->update('sales', ['paid' => 0, 'status' => 'due'], ['id' => $sale_id]);
                        $msg[] = lang('payment_failed');
                        $msg[] = '<p class="text-danger">' . $result['code'] . ': ' . $result['message'] . '</p>';
                    }
                } else {
                    if ($payment['paid_by'] == 'gift_card') {
                        $gc = $this->getGiftCardByNO($payment['gc_no']);
                        $this->db->update('gift_cards', array('balance' => ($gc->balance-$payment['amount'])), array('card_no' => $payment['gc_no']));
                    }
                    unset($payment['cc_cvv2']);
                    $payment['sale_id'] = $sale_id;
                    $this->db->insert('payments', $payment);
                }
            }
            $Settings = $this->site->getSettings();
            if($Settings->hold_customer){
                $show_customer = array('hide' => 0);
                $this->db->update('customers',$show_customer,array('id' => $data['customer_id']));
            }
            if($Settings->waiting_number<99){
                $this->db->set('waiting_number','waiting_number+1',FALSE); 
                $this->db->where('setting_id',1);
                $this->db->update('settings');
                $this->db->update('sales',array('waiting_number'=>$Settings->waiting_number+1),array('id'=>$sale_id));                
            } else {
                $this->db->set('waiting_number',1);
                $this->db->where('setting_id',1);
                $this->db->update('settings');
                $this->db->update('sales',array('waiting_number'=>1),array('id'=>$sale_id));
            }            
            return array('sale_id' => $sale_id, 'message' => $msg);
            }

        return false;
    }

    function stripe($amount = 0, $card_info = array(), $desc = '') {
        $this->load->model('stripe_payments');
        // $card_info = array( "number" => "4242424242424242", "exp_month" => 1, "exp_year" => 2016, "cvc" => "314" );
        // $amount = $amount ? $amount*100 : 3000;
        $amount = $amount * 100;
        if ($amount && !empty($card_info)) {
            $token_info = $this->stripe_payments->create_card_token($card_info);
            if (!isset($token_info['error'])) {
                $token = $token_info->id;
                $data = $this->stripe_payments->insert($token, $desc, $amount, $this->Settings->currency_prefix);
                if (!isset($data['error'])) {
                    $result = array('transaction_id' => $data->id,
                        'created_at' => date('Y-m-d H:i:s', $data->created),
                        'amount' => ($data->amount / 100),
                        'currency' => strtoupper($data->currency)
                    );
                    return $result;
                } else {
                    return $data;
                }
            } else {
                return $token_info;
            }
        }
        return false;
    }

    public function updateSale($id, $data, $items) {
        $osale = $this->getSaleByID($id);
        $oitems = $this->getAllSaleItems($id);
        ($this->Settings->multistore_quantity) ? $store_id = 1 : $store_id = $osale->store_id;
        foreach ($oitems as $oitem) {
            $product = $this->site->getProductByID($oitem->product_id, $store_id);
            if ($product->type == 'standard' || $product->type == 'other') {                
                if ($this->getStoreQuantity($oitem->product_id, $store_id)) {                    
                    $this->db->update('product_store_qty', array('quantity' => ($product->quantity+($oitem->quantity*($oitem->length>0?$oitem->length:1)))), array('product_id' => $product->id, 'store_id' => $store_id));
                } else {
                    $store_quantity = array(
                        'product_id' => $oitem->product_id,
                        'store_id' => $store_id,
                        'quantity' => $product->quantity+($oitem->quantity*($oitem->length>0?$oitem->length:1)),
                        'price' => $product->price,
                        'price_wholesale' => $product->price_wholesale,
                        'price_vip' => $product->price_vip                    
                        );
                    $this->db->insert('product_store_qty', $store_quantity);
                }
            } elseif ($product->type == 'combo') {
                $combo_items = $this->getComboItemsByPID($product->id);
                foreach ($combo_items as $combo_item) {
                    $cpr = $this->site->getProductByID($combo_item->id, $store_id);
                    if($cpr->type == 'standard' || $cpr->type == 'other') {
                        $qty = $combo_item->qty * $oitem->quantity * ($oitem->length>0?$oitem->length:1);                        
                        if ($this->getStoreQuantity($cpr->id, $data['store_id'])) {
                            $this->db->update('product_store_qty', array('quantity' => ($cpr->quantity+$qty)), array('product_id' => $cpr->id, 'store_id' => $store_id));
                        } else {
                            $store_quantity = array(
                                'product_id' => $cpr->id,
                                'store_id' => $store_id,
                                'quantity' => $cpr->quantity+$qty,
                                'price' => $cpr->price,
                                'price_wholesale' => $cpr->price_wholesale,
                                'price_vip' => $cpr->price_vip                    
                                );
                            $this->db->insert('product_store_qty', $store_quantity);
                        }
                    }
                }
            }
        }

        //$data['status'] = $osale->paid > 0 ? 'partial' : ($data['grand_total'] <= $osale->paid ? 'paid' : 'due');
        $data['status'] = ($osale->paid - $data['grand_total']) < 0 ? 'partial' : ($data['grand_total'] <= $osale->paid ? 'paid' : 'due');
        if($osale->paid == 0) { $data['status'] = 'due';}

        if($this->db->update('sales', $data, array('id' => $id)) && $this->db->delete('sale_items', array('sale_id' => $id))) {

            foreach ($items as $item) {
                $item['sale_id'] = $id;
                if($this->db->insert('sale_items', $item)) {
                    $product = $this->site->getProductByID($item['product_id'], $store_id);
                    if ($product->type == 'standard' || $product->type == 'other') {
                        $this->db->update('product_store_qty', array('quantity' => ($product->quantity-($item['quantity']*($item['length']>0?$item['length']:1)))), array('product_id' => $product->id, 'store_id' => $store_id));
                    } elseif ($product->type == 'combo') {
                        $combo_items = $this->getComboItemsByPID($product->id);
                        foreach ($combo_items as $combo_item) {
                            $cpr = $this->site->getProductByID($combo_item->id, $store_id);
                            if($cpr->type == 'standard' || $cpr->type == 'other') {
                                $qty = $combo_item->qty * $item['quantity'] * ($item['length']>0?$item['length']:1);
                                $this->db->update('product_store_qty', array('quantity' => ($cpr->quantity-$qty)), array('product_id' => $cpr->id, 'store_id' => $store_id));
                            }
                        }
                    }
                }
            }

            return TRUE;
            }

        return false;
    }

    public function suspendSale($data, $items, $did = NULL) {
        unset($data['total_cost']);
        if($did) {

            $gee = $this->db->get_where('suspended_sales', array('id' => $did));
			$oid = $gee->row()->customer_id;

			if($oid <> $data['customer_id'])
			{
				$hide_customer = array('hide' => 0);
				$this->db->update('customers',$hide_customer,array('id' => $oid));
			}

            if($this->db->update('suspended_sales', $data, array('id' => $did)) && $this->db->delete('suspended_items', array('suspend_id' => $did))) {
                foreach ($items as $item) {
                    unset($item['cost']);
                    $item['suspend_id'] = $did;
                    $this->db->insert('suspended_items', $item);
                }
                $Settings = $this->site->getSettings();
                if($Settings->hold_customer){
                    $hide_customer = array('hide' => 1);
                    $this->db->update('customers',$hide_customer,array('id' => $data['customer_id']));
                }
                return TRUE;
            }

        } else {
            $data['date_in'] = $data['date'];
            if($this->db->insert('suspended_sales', $data)) {
                $suspend_id = $this->db->insert_id();
                foreach ($items as $item) {
                    unset($item['cost']);
                    $item['suspend_id'] = $suspend_id;
                    $this->db->insert('suspended_items', $item);
                }
                $Settings = $this->site->getSettings();
                if($Settings->hold_customer){
                    $hide_customer = array('hide' => 1);
                    $this->db->update('customers',$hide_customer,array('id' => $data['customer_id']));
                }
                return $suspend_id;
            }
        }
        return false;
    }

    public function getSaleByID($sale_id) {
        $q = $this->db->get_where('sales', array('id' => $sale_id), 1);
          if( $q->num_rows() > 0 ) {
            return $q->row();
          }
          return FALSE;
    }

    public function getAllSaleItems($sale_id) {
        $j = "(SELECT id, code, name, tax_method from {$this->db->dbprefix('products')}) P";
        $this->db->select("sale_items.*,
            (CASE WHEN {$this->db->dbprefix('sale_items')}.product_code IS NULL THEN {$this->db->dbprefix('products')}.code ELSE {$this->db->dbprefix('sale_items')}.product_code END) as product_code,
            (CASE WHEN {$this->db->dbprefix('sale_items')}.product_name IS NULL THEN {$this->db->dbprefix('products')}.name ELSE {$this->db->dbprefix('sale_items')}.product_name END) as product_name,
            {$this->db->dbprefix('unit')}.name as unit,
            {$this->db->dbprefix('products')}.beverage as beverage,
            {$this->db->dbprefix('products')}.tax_method as tax_method", FALSE)
        ->join('products', 'products.id=sale_items.product_id', 'left outer')
        ->join('unit','unit.id=products.unit_id','left')
        ->order_by('sale_items.id','desc');
        $q = $this->db->get_where('sale_items', array('sale_id' => $sale_id));
        if($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }

    public function getBeverageSaleItems($sale_id) {
        $j = "(SELECT id, code, name, tax_method from {$this->db->dbprefix('products')}) P";
        $this->db->select("sale_items.*,
            (CASE WHEN {$this->db->dbprefix('sale_items')}.product_code IS NULL THEN {$this->db->dbprefix('products')}.code ELSE {$this->db->dbprefix('sale_items')}.product_code END) as product_code,
            (CASE WHEN {$this->db->dbprefix('sale_items')}.product_name IS NULL THEN {$this->db->dbprefix('products')}.name ELSE {$this->db->dbprefix('sale_items')}.product_name END) as product_name,
            {$this->db->dbprefix('unit')}.name as unit,
            {$this->db->dbprefix('products')}.beverage as beverage,
            {$this->db->dbprefix('products')}.tax_method as tax_method", FALSE)
        ->join('products', 'products.id=sale_items.product_id', 'left outer')
        ->join('unit','unit.id=products.unit_id','left')
        ->order_by('sale_items.id','desc');
        $q = $this->db->get_where('sale_items', array('sale_id' => $sale_id, 'beverage' => 1));
        if($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }

    public function getAllSaleGroupItems($sale_id) {
        $j = "(SELECT id, code, name, tax_method from {$this->db->dbprefix('products')}) P";
        $this->db->select("sale_items.*, SUM(sale_items.quantity) AS sold,
            (CASE WHEN {$this->db->dbprefix('sale_items')}.product_code IS NULL THEN {$this->db->dbprefix('products')}.code ELSE {$this->db->dbprefix('sale_items')}.product_code END) as product_code,
            (CASE WHEN {$this->db->dbprefix('sale_items')}.product_name IS NULL THEN {$this->db->dbprefix('products')}.name ELSE {$this->db->dbprefix('sale_items')}.product_name END) as product_name,
            {$this->db->dbprefix('unit')}.name as unit,
            {$this->db->dbprefix('products')}.tax_method as tax_method", FALSE)
        ->join('products', 'products.id=sale_items.product_id', 'left outer')
        ->join('unit','unit.id=products.unit_id','left')        
        ->group_by('sale_items.product_id')
        ->order_by('sale_items.id','desc');    
        $q = $this->db->get_where('sale_items', array('sale_id' => $sale_id));        
        if($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }

    public function getAllSalePayments($sale_id) {
        $q = $this->db->get_where('payments', array('sale_id' => $sale_id));
        if($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }

    public function getSuspendedSaleByID($id) {
        $q = $this->db->get_where('suspended_sales', array('id' => $id), 1);
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    }

    public function getSuspendedSaleItems($id) {
        $q = $this->db->get_where('suspended_items', array('suspend_id' => $id));
        if ($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }

    public function getSuspendedSales($user_id = NULL) {
        if (!$user_id) {
            $user_id = $this->session->userdata('user_id');
        }
        $this->db->order_by('date', 'desc');
        $q = $this->db->get_where('suspended_sales', array('created_by' => $user_id));
        if ($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }

    public function getGiftCardByNO($no) {
        $q = $this->db->get_where('gift_cards', array('card_no' => $no), 1);
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    }

    public function getComboItemsByPID($product_id) {
        $this->db->select($this->db->dbprefix('products') . '.id as id, ' . $this->db->dbprefix('products') . '.code as code, ' . $this->db->dbprefix('combo_items') . '.quantity as qty, ' . $this->db->dbprefix('products') . '.name as name, ' . $this->db->dbprefix('products') . '.quantity as quantity')
        ->join('products', 'products.code=combo_items.item_code', 'left')
        ->group_by('combo_items.id');
        $q = $this->db->get_where('combo_items', array('product_id' => $product_id));
        if ($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }

    public function resetWaitingNumber() {
        if ($this->db->update('settings', array('waiting_number' => 0), array('setting_id' => 1))) {
            return true;
        }
        return FALSE;
    }

    public function getCategoryDiscount($id) {
        $q = $this->db->get_where('categories', array('id' => $id), 1);
          if( $q->num_rows() > 0 ) {
            return $q->row()->discount;
          }
          return FALSE;
    }

    public function getStoreInvNumber($store_id) {
        $this->db->select('inv_number');
        $this->db->from('stores');
        $this->db->where('id',$store_id);
        return $this->db->get()->row()->inv_number + 1;
    }

    public function getRegisterSalesDiscountTax($date = NULL, $user_id = NULL) {
        if (!$date) {
            $date = $this->session->userdata('register_open_time');
        }
        if (!$user_id) {
            $user_id = $this->session->userdata('user_id');
        }
        $this->db->select('SUM( COALESCE( order_tax, 0 ) ) AS order_tax, SUM( COALESCE( product_tax, 0 ) ) AS product_tax, SUM( COALESCE( total_tax, 0 ) ) AS total_tax, SUM( COALESCE(total, 0 ) ) AS total, SUM( COALESCE(grand_total, 0 ) ) AS grand_total, SUM( COALESCE(paid, 0 ) ) AS paid,  SUM( COALESCE( total_discount, 0 ) ) AS total_discount, SUM( COALESCE( product_discount, 0 ) ) AS product_discount,  SUM( COALESCE( order_discount, 0 ) ) AS order_discount', FALSE)
            ->where('date >', $date);
        $this->db->where('created_by', $user_id);

        $q = $this->db->get('sales');
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return false;
    }

    public function getTotalCustomerSales($customer_id, $user = NULL, $start_date = NULL, $end_date = NULL) {
        $this->db->select('COUNT(id) as number, sum(grand_total) as amount, sum(paid) as paid');
        if ($start_date && $end_date) {
            $this->db->where('date >=', $start_date);
            $this->db->where('date <=', $end_date);
        }
        if ($user) {
            $this->db->where('created_by', $user);
        }
        if ($this->session->userdata('store_id')) {
            $this->db->where('store_id', $this->session->userdata('store_id'));
        }
        $q = $this->db->get_where('sales', array('customer_id' => $customer_id));
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    }

    public function getStoreQuantity($product_id, $store_id = NULL) {
        if(!$store_id) {
            $store_id = $this->session->userdata('store_id') ? $this->session->userdata('store_id') : 1;
        }
        $q = $this->db->get_where('product_store_qty', array('product_id' => $product_id, 'store_id' => $store_id), 1);
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    }

    public function getSummaryCategories($sale_id) {
        $this->db->select("{$this->db->dbprefix('sale_items')}.product_id, {$this->db->dbprefix('sale_items')}.product_name, {$this->db->dbprefix('categories')}.name as name, SUM({$this->db->dbprefix('sale_items')}.subtotal) as subtotal")
        ->join('products', 'products.id=sale_items.product_id', 'left')
        ->join('categories', 'categories.id=products.category_id', 'left')
        ->group_by('categories.id');
        $q = $this->db->get_where('sale_items', array('sale_id' => $sale_id));
        if($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }

    public function getRegisterSaleInvoices($date = NULL, $user_id = NULL) {
        if (!$date) {
            $date = $this->session->userdata('register_open_time');
        }
        if (!$user_id) {
            $user_id = $this->session->userdata('user_id');
        }
        $this->db->select('sales.*')
            ->where('date >', $date);;
        $q = $this->db->get_where('sales', array('created_by' => $user_id));
        if($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }

    public function getDue($customerid) {      
        $this->db->select("customer_id,sum(grand_total-paid) as pdue");
        $q = $this->db->get_where('sales', array('customer_id' => $customerid), 1);
          if( $q->num_rows() > 0 ) {
            return $q->row();
          }
          return FALSE;
    }

}
