<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Adjustments_model extends CI_Model
{

    public function __construct() {
        parent::__construct();
    }

    public function getProductByID($id) {
        $q = $this->db->get_where('products', array('id' => $id), 1);
        if( $q->num_rows() > 0 ) {
            return $q->row();
        }
        return FALSE;
    }

    public function getAdjustmentByID($id) {
        $q = $this->db->get_where('adjustments', array('id' => $id), 1);
        if( $q->num_rows() > 0 ) {
            return $q->row();
        }
        return FALSE;
    }

    public function getAllAdjustmentItems($adjustment_id) {
        $this->db->select('adjustment_items.*, products.code as product_code, products.name as product_name, unit.name as product_unit')
            ->join('products', 'products.id=adjustment_items.product_id', 'left')
            ->join('unit','unit.id=products.unit_id','left')
            ->group_by('adjustment_items.id')
            ->order_by('id', 'asc');
        $q = $this->db->get_where('adjustment_items', array('adjustment_id' => $adjustment_id));
        if ($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }

    public function addAdjustment($data, $items) {
        if ($this->db->insert('adjustments', $data)) {
            $adjustment_id = $this->db->insert_id();
            foreach ($items as $item) {
                $item['adjustment_id'] = $adjustment_id;
                if ($this->db->insert('adjustment_items', $item)) {
                    $this->setStoreQuantity($item['product_id'], $data['store_id'], $item['quantity'], $item['type']);                    
                }
            }
            return true;
        }
        return false;
    }

    public function setStoreQuantity($product_id, $store_id, $quantity, $type) {
        if ($store_qty = $this->getStoreQuantity($product_id, $store_id)) {
            if ($type == 'add') {
                $this->db->update('product_store_qty', array('quantity' => ($store_qty->quantity+$quantity)), array('product_id' => $product_id, 'store_id' => $store_id));
            } else {
                $this->db->update('product_store_qty', array('quantity' => ($store_qty->quantity-$quantity)), array('product_id' => $product_id, 'store_id' => $store_id));
            }
        } else {
            if ($type == 'add') {
                $this->db->insert('product_store_qty', array('product_id' => $product_id, 'store_id' => $store_id, 'quantity' => $quantity));
            } else {
                $this->db->insert('product_store_qty', array('product_id' => $product_id, 'store_id' => $store_id, 'quantity' => -$quantity));
            }
        }
    }

    public function getStoreQuantity($product_id, $store_id) {
        $q = $this->db->get_where('product_store_qty', array('product_id' => $product_id, 'store_id' => $store_id), 1);
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    }

    public function updateAdjustment($id, $data = NULL, $items = array()) {
        $adjustment = $this->getAdjustmentByID($id);
        $oitems = $this->getAllAdjustmentItems($id);
        foreach ($oitems as $oitem) {
            if ($product = $this->site->getProductByID($oitem->product_id)) {
                $this->setStoreQuantity($oitem->product_id, $adjustment->store_id, (0-$oitem->quantity), $oitem->type);
            }
        }        
        if ($this->db->update('adjustments', $data, array('id' => $id)) && $this->db->delete('adjustment_items', array('adjustment_id' => $id))) {
            foreach ($items as $item) {
                $item['adjustment_id'] = $id;
                if ($this->db->insert('adjustment_items', $item)) {
                    if ($product = $this->site->getProductByID($item['product_id'])) {
                        $this->setStoreQuantity($item['product_id'], $adjustment->store_id, $item['quantity'], $item['type']);
                    }
                }
            }
            return true;
        }
        return false;
    }

    public function deleteAdjustment($id) {
        $adjustment = $this->getAdjustmentByID($id);
        $oitems = $this->getAllAdjustmentItems($id);
        foreach ($oitems as $oitem) {
            if ($product = $this->site->getProductByID($oitem->product_id)) {
                $this->setStoreQuantity($oitem->product_id, $adjustment->store_id, (0-$oitem->quantity), $oitem->type);
            }
        }
        
        if ($this->db->delete('adjustments', array('id' => $id)) && $this->db->delete('adjustment_items', array('adjustment_id' => $id))) {
            return true;
        }
        return FALSE;
    }

    public function getProductNames($term, $limit = 10) {
        if ($this->db->dbdriver == 'sqlite3') {
            $this->db->where("type != 'combo' AND (name LIKE '%" . $term . "%' OR code LIKE '%" . $term . "%' OR  (name || ' (' || code || ')') LIKE '%" . $term . "%' OR second_name LIKE '%" . $term . "%')");
        } else {
            $this->db->where("type != 'combo' AND (name LIKE '%" . $term . "%' OR code LIKE '%" . $term . "%' OR  concat(name, ' (', code, ')') LIKE '%" . $term . "%' OR second_name LIKE '%" . $term . "%')");
        }
        $this->db->limit($limit);
        $q = $this->db->get('products');
        if ($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }

}
