<?php defined('BASEPATH') OR exit('No direct script access allowed');

class MY_Controller extends CI_Controller {

    function __construct() {
        parent::__construct();

        $this->Settings = $this->site->getSettings();
        if($spos_language = $this->input->cookie('spos_language', TRUE)) {
            $this->Settings->selected_language = $spos_language;
            $this->config->set_item('language', $spos_language);
            $this->lang->load('app', $spos_language);
        } else {
            $this->Settings->selected_language = $this->Settings->language;
            $this->config->set_item('language', $this->Settings->language);
            $this->lang->load('app', $this->Settings->language);
        }
        $this->Settings->pin_code = $this->Settings->pin_code ? md5($this->Settings->pin_code) : NULL;
        $this->theme = $this->Settings->theme.'/views/';
        $this->data['assets'] = base_url() . 'themes/default/assets/';
        $this->data['Settings'] = $this->Settings;
        $this->loggedIn = $this->tec->logged_in();
        $this->data['loggedIn'] = $this->loggedIn;
        $this->data['store'] = $this->site->getStoreByID($this->session->userdata('store_id'));
        $this->data['categories'] = $this->site->getAllCategories();
        $this->Admin = $this->tec->in_group('admin') ? TRUE : NULL;
        $this->data['Admin'] = $this->Admin;
        $this->Staff = $this->tec->in_group('staff') ? TRUE : NULL;
        $this->data['Staff'] = $this->Staff;
        $this->Stock = $this->tec->in_group('stock') ? TRUE : NULL;
        $this->data['Stock'] = $this->Stock;
        $this->Manager = $this->tec->in_group('manager') ? TRUE : NULL;
        $this->data['Manager'] = $this->Manager;
        $this->Print = $this->tec->in_group('print') ? TRUE : NULL;
        $this->data['Print'] = $this->Print;
        $this->SalesReport = $this->tec->in_group('salesreport') ? TRUE : NULL;
        $this->data['SalesReport'] = $this->SalesReport;
        $this->AllReports = $this->tec->in_group('allreports') ? TRUE : NULL;
        $this->data['AllReports'] = $this->AllReports;
        $this->Order = $this->tec->in_group('order') ? TRUE : NULL;
        $this->data['Order'] = $this->Order;
        $this->Supervisor = $this->tec->in_group('supervisor') ? TRUE : NULL;
        $this->data['Supervisor'] = $this->Supervisor;
        $this->m = strtolower($this->router->fetch_class());
        $this->v = strtolower($this->router->fetch_method());
        $this->data['m']= $this->m;
        $this->data['v'] = $this->v;
    }

    function page_construct($page, $data = array(), $meta = array()) {
        if(empty($meta)) { $meta['page_title'] = $data['page_title']; }
        $meta['message'] = isset($data['message']) ? $data['message'] : $this->session->flashdata('message');
        $meta['error'] = isset($data['error']) ? $data['error'] : $this->session->flashdata('error');
        $meta['warning'] = isset($data['warning']) ? $data['warning'] : $this->session->flashdata('warning');
        $meta['ip_address'] = $this->input->ip_address();
        $meta['Admin'] = $data['Admin'];
        $meta['Staff'] = $data['Staff'];
        $meta['Stock'] = $data['Stock'];
        $meta['Manager'] = $data['Manager'];
        $meta['Print'] = $data['Print'];
        $meta['SalesReport'] = $data['SalesReport'];
        $meta['AllReports'] = $data['AllReports'];
        $meta['Order'] = $data['Order'];
        $meta['Supervisor'] = $data['Supervisor'];
        $meta['loggedIn'] = $data['loggedIn'];
        $meta['Settings'] = $data['Settings'];
        $meta['assets'] = $data['assets'];
        $meta['store'] = $data['store'];
        $meta['suspended_sales'] = $this->site->getUserSuspenedSales();
        $meta['qty_alert_num'] = $this->site->getQtyAlerts();
        $meta['day_alert_num'] = $this->site->getDayAlerts();
        $meta['service_alert_num'] = $this->site->getServiceAlerts();
        $meta['payment_alert_num'] = $this->site->getPaymentAlerts();
        $this->load->view($this->theme . 'header', $meta);
        $this->load->view($this->theme . $page, $data);
        $this->load->view($this->theme . 'footer');
    }
}
