<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Adjustments extends MY_Controller
{

    function __construct() {
        parent::__construct();

        if (!$this->loggedIn) {
            redirect('login');
        }
        if ( ! $this->session->userdata('store_id')) {
            $this->session->set_flashdata('warning', lang("please_select_store"));
            redirect('stores');
        }
        $this->load->library('form_validation');
        $this->load->model('adjustments_model');
        $this->load->model('products_model');
        $this->load->model('reports_model');
        $this->allowed_types = 'gif|jpg|png|pdf|doc|docx|xls|xlsx|zip';
    }

    function index() {
        if ($this->Staff) {
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect('pos');
        }
        $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));        
        $this->data['users'] = $this->reports_model->getAllStaff();
        $this->data['page_title'] = lang('adjustments');
        $bc = array(array('link' => '#', 'page' => lang('adjustments')));
        $meta = array('page_title' => lang('adjustments'), 'bc' => $bc);
        $this->page_construct('adjustments/index', $this->data, $meta);

    }
	
	function get_adjustments() {
        $start_date = $this->input->get('start_date') ? $this->input->get('start_date') : NULL;
        $end_date = $this->input->get('end_date') ? $this->input->get('end_date') : NULL;
        $user = $this->input->get('user') ? $this->input->get('user') : NULL;
        if ($this->Staff) {
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect('pos');
        }
        $this->load->library('datatables');		
        $this->datatables
         ->select("adjustments.id, adjustments.date, adjustments.reference, adjustments.note, adjustments.attachment")
         ->from('adjustments');	
        if (! ($this->Admin || $this->Manager) && !$this->session->userdata('view_right')) {
            $this->datatables->where('created_by', $this->session->userdata('user_id'));
            $this->datatables->where('store_id', $this->session->userdata('store_id'));
        }
        
        $this->datatables->add_column("Actions", "<div class='text-center'><div class='btn-group'><a href='".site_url('adjustments/view/$1')."' title='".lang('view_adjustment')."' class='tip btn btn-primary btn-xs' data-toggle='ajax-modal'><i class='fa fa-file-text-o'></i></a> <a href='" . site_url('adjustments/edit/$1') . "' title='" . lang("edit_adjustment") . "' class='tip btn btn-warning btn-xs'><i class='fa fa-edit'></i></a> <a href='" . site_url('adjustments/delete/$1') . "' onClick=\"return confirm('" . lang('alert_x_adjustment') . "')\" title='" . lang("delete_adjustment") . "' class='tip btn btn-danger btn-xs'><i class='fa fa-trash-o'></i></a></div></div>", "id");

        $this->datatables->unset_column('id');
        if($user) { $this->datatables->where('created_by', $user); }
        if($start_date) { $this->datatables->where('date >=', $start_date . ' 00:00'); }
        if($end_date) { $this->datatables->where('date <=', $end_date . ' 23:59'); }
        echo $this->datatables->generate();

    }

    function view($id = NULL) {
        if ( ! ($this->Admin || $this->Manager)) {
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect('pos');
        }
        $this->data['adjustment'] = $this->adjustments_model->getAdjustmentByID($id);
        $this->data['items'] = $this->adjustments_model->getAllAdjustmentItems($id);
        $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
        $this->data['page_title'] = lang('view_adjustment');
        $this->load->view($this->theme.'adjustments/view', $this->data);

    }

    function add() {
        if ( ! $this->session->userdata('store_id')) {
            $this->session->set_flashdata('warning', lang("please_select_store"));
            redirect('stores');
        }
        if ($this->Staff) {
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect('pos');
        }
        $this->form_validation->set_rules('date', lang('date'), 'required');

        if ($this->form_validation->run() == true) {            
            $quantity = "quantity";
            $product_id = "product_id";
            $type = "type";
            $i = isset($_POST['product_id']) ? sizeof($_POST['product_id']) : 0;
            for ($r = 0; $r < $i; $r++) {
                $item_id = $_POST['product_id'][$r];
                $item_qty = $_POST['quantity'][$r];
                $item_type = $_POST['type'][$r];
                if( $item_id && $item_qty && $type ) {

                    if(!$this->adjustments_model->getProductByID($item_id)) {
                        $this->session->set_flashdata('error', $this->lang->line("product_not_found")." ( ".$item_id." ).");
                        redirect('adjustments/add');
                    }

                    $products[] = array(
                        'product_id' => $item_id,
                        'quantity' => $item_qty,
                        'type' => $item_type                        
                        );                   
                }
            }

            if (!isset($products) || empty($products)) {
                $this->form_validation->set_rules('product', lang("product"), 'required');
            } else {
                krsort($products);
            }
            
            $store_id = $this->input->post('store_id') ? $this->input->post('store_id') : $this->session->userdata('store_id');

            $data = array(
                        'date' => $this->input->post('date'),
                        'reference' => $this->input->post('reference'),
                        'note' => $this->input->post('note', TRUE),
                        'created_by' => $this->session->userdata('user_id'),
                        'store_id' => $store_id,
                    );

            if ($_FILES['userfile']['size'] > 0) {

                $this->load->library('upload');
                $config['upload_path'] = 'uploads/';
                $config['allowed_types'] = $this->allowed_types;
                $config['max_size'] = '2000';
                $config['overwrite'] = FALSE;
                $config['encrypt_name'] = TRUE;
                $this->upload->initialize($config);

                if (!$this->upload->do_upload()) {
                    $error = $this->upload->display_errors();
                    $this->upload->set_flashdata('error', $error);
                    redirect("adjustments/add");
                }

                $data['attachment'] = $this->upload->file_name;

            }
            // $this->tec->print_arrays($data, $products);
        }

        if ($this->form_validation->run() == true && $this->adjustments_model->addAdjustment($data, $products)) {

            $this->session->set_userdata('remove_spo', 1);
            $this->session->set_flashdata('message', lang('adjustment_added'));
            redirect("adjustments");

        } else {

            $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));            
            $this->data['stores'] = $this->site->getAllStores();
            $this->data['page_title'] = lang('add_adjustment');
            $bc = array(array('link' => site_url('adjustments'), 'page' => lang('adjustments')), array('link' => '#', 'page' => lang('add_adjustment')));
            $meta = array('page_title' => lang('add_adjustment'), 'bc' => $bc);
            $this->page_construct('adjustments/add', $this->data, $meta);

        }
    }

    function edit($id = NULL) {
        if ( ! ($this->Admin || $this->Manager)) {
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect('pos');
        }
        if ($this->input->get('id')) {
            $id = $this->input->get('id');
        }

        $this->form_validation->set_rules('date', lang('date'), 'required');

        if ($this->form_validation->run() == true) {            
            $quantity = "quantity";
            $product_id = "product_id";
            $type = "type";
            $i = isset($_POST['product_id']) ? sizeof($_POST['product_id']) : 0;
            for ($r = 0; $r < $i; $r++) {
                $item_id = $_POST['product_id'][$r];
                $item_qty = $_POST['quantity'][$r];
                $item_type = $_POST['type'][$r];
                if( $item_id && $item_qty && $type ) {

                    if(!$this->site->getProductByID($item_id)) {
                        $this->session->set_flashdata('error', $this->lang->line("product_not_found")." ( ".$item_id." ).");
                        redirect('adjustments/edit/'.$id);
                    }

                    $products[] = array(
                        'product_id' => $item_id,                        
                        'quantity' => $item_qty,
                        'type' => $item_type,
                        );
                }
            }

            if (!isset($products) || empty($products)) {
                $this->form_validation->set_rules('product', lang("product"), 'required');
            } else {
                krsort($products);
            }

            $store_id = $this->input->post('store_id') ? $this->input->post('store_id') : $this->session->userdata('store_id');

            $data = array(
                        'date' => $this->input->post('date'),
                        'reference' => $this->input->post('reference'),
                        'note' => $this->input->post('note', TRUE),
                        'store_id' => $store_id,
                    );

            if ($_FILES['userfile']['size'] > 0) {

                $this->load->library('upload');
                $config['upload_path'] = 'uploads/';
                $config['allowed_types'] = $this->allowed_types;
                $config['max_size'] = '2000';
                $config['overwrite'] = FALSE;
                $config['encrypt_name'] = TRUE;
                $this->upload->initialize($config);

                if (!$this->upload->do_upload()) {
                    $error = $this->upload->display_errors();
                    $this->upload->set_flashdata('error', $error);
                    redirect("adjustments/add");
                }

                $data['attachment'] = $this->upload->file_name;

            }
            // $this->tec->print_arrays($data, $products);
        }

        if ($this->form_validation->run() == true && $this->adjustments_model->updateAdjustment($id, $data, $products)) {

            $this->session->set_userdata('remove_spo', 1);
            $this->session->set_flashdata('message', lang('adjustment_updated'));
            redirect("adjustments");

        } else {

            $this->data['adjustment'] = $this->adjustments_model->getAdjustmentByID($id);
            $inv_items = $this->adjustments_model->getAllAdjustmentItems($id);
            $c = rand(100000, 9999999);
            foreach ($inv_items as $item) {
                $row = $this->site->getProductByID($item->product_id);
                $row->qty = $item->quantity;
                $row->type = $item->type;
                $unit = $this->site->getUnitByID($row->unit_id);
                $ri = $this->Settings->item_addition ? $row->id : $c;
                $pr[$ri] = array('id' => $ri, 'item_id' => $row->id, 'label' => $row->name . " (" . $row->code . ")", 'row' => $row, 'product_unit' => $unit->name);
                $c++;
            }

            $this->data['items'] = json_encode($pr);
            $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
            $this->data['stores'] = $this->site->getAllStores();
            $this->data['page_title'] = lang('edit_adjustment');
            $bc = array(array('link' => site_url('adjustments'), 'page' => lang('adjustments')), array('link' => '#', 'page' => lang('edit_adjustment')));
            $meta = array('page_title' => lang('edit_adjustment'), 'bc' => $bc);
            $this->page_construct('adjustments/edit', $this->data, $meta);

        }
    }

    function delete($id = NULL) {
        if(DEMO) {
            $this->session->set_flashdata('error', lang('disabled_in_demo'));
            redirect(isset($_SERVER["HTTP_REFERER"]) ? $_SERVER["HTTP_REFERER"] : 'welcome');
        }
        if ( ! ($this->Admin || $this->Manager)) {
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect('pos');
        }
        if ($this->input->get('id')) {
            $id = $this->input->get('id');
        }

        if ($this->adjustments_model->deleteAdjustment($id)) {
            $this->session->set_flashdata('message', lang("adjustment_deleted"));
            redirect('adjustments');
        }
    }

    function suggestions($id = NULL) {
        if($id) {
            $row = $this->site->getProductByID($id);
            $row->qty = 1;
            $unit = $this->site->getUnitByID($row->unit_id);
            $pr = array('id' => str_replace(".", "", microtime(true)), 'item_id' => $row->id, 'label' => $row->name . " (" . $row->code . ")", 'row' => $row, 'product_unit' => $unit->name);
            echo json_encode($pr);
            die();
        }
        $term = $this->input->get('term', TRUE);
        $rows = $this->adjustments_model->getProductNames($term);
        if ($rows) {
            foreach ($rows as $row) {
                $row->qty = 1;
                $unit = $this->site->getUnitByID($row->unit_id);
                $pr[] = array('id' => str_replace(".", "", microtime(true)), 'item_id' => $row->id, 'label' => $row->name . " (" . $row->code . ")", 'row' => $row, 'product_unit' => $unit->name);
            }
            echo json_encode($pr);
        } else {
            echo json_encode(array(array('id' => 0, 'label' => lang('no_match_found'), 'value' => $term)));
        }
    }

    function import() {
        if ($this->Staff) {
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect('pos');
        }
        if ( ! $this->session->userdata('store_id')) {
            $this->session->set_flashdata('warning', lang("please_select_store"));
            redirect('stores');
        }
        if ($this->Staff) {
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect('pos');
        }
        $this->form_validation->set_rules('date', lang('date'), 'required');
        $this->load->helper('security');
        $this->form_validation->set_rules('userfile', lang("upload_file"), 'xss_clean');

        if ($this->form_validation->run() == true) {
            if (DEMO) {
                $this->session->set_flashdata('warning', lang("disabled_in_demo"));
                redirect('pos');
            }
            
            if (isset($_FILES["userfile"])) {

                $this->load->library('upload');

                $config['upload_path'] = 'uploads/';
                $config['allowed_types'] = 'csv';
                $config['max_size'] = '2000';
                $config['overwrite'] = TRUE;

                $this->upload->initialize($config);

                if (!$this->upload->do_upload()) {
                    $error = $this->upload->display_errors();
                    $this->session->set_flashdata('error', $error);
                    redirect("adjustments/import");
                }


                $csv = $this->upload->file_name;

                $arrResult = array();
                $handle = fopen("uploads/" . $csv, "r");
                if ($handle) {
                    while (($row = fgetcsv($handle, 1000, ",")) !== FALSE) {
                        $arrResult[] = $row;
                    }
                    fclose($handle);
                }
                array_shift($arrResult);

                $keys = array('code', 'qty', 'type');

                $final = array();
                foreach ($arrResult as $key => $value) {
                    $final[] = array_combine($keys, $value);
                }

                if (sizeof($final) > 10001) {
                    $this->session->set_flashdata('error', lang("more_than_allowed"));
                    redirect("adjustments/import");
                }

                foreach ($final as $csv_pr) {
                    if (! ($prod = $this->products_model->getProductByCode($csv_pr['code']))) {
                        $this->session->set_flashdata('error', lang("check_product_code") . " (" . $csv_pr['code'] . "). " . lang("code_x_exist"));
                        redirect("adjustments/import");
                    }

                    $products[] = array(
                        'product_id' => $prod->id,                        
                        'quantity' => $csv_pr['qty'],
                        'type' => $csv_pr['type']
                    );

                }
            }

            $data = array(
                'date' => $this->input->post('date'),
                'reference' => $this->input->post('reference'),
                'note' => $this->input->post('note', TRUE),
                'created_by' => $this->session->userdata('user_id'),
                'store_id' => $this->session->userdata('store_id'),
            );


        }

        if ($this->form_validation->run() == true && $this->adjustments_model->addAdjustment($data, $products)) {

            $this->session->set_userdata('remove_spo', 1);
            $this->session->set_flashdata('message', lang('purchase_added'));
            redirect("adjustments");

        } else {

            $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
            $this->data['page_title'] = lang('import_adjustments');
            $bc = array(array('link' => site_url('adjustments'), 'page' => lang('adjustments')), array('link' => '#', 'page' => lang('import_adjustments')));
            $meta = array('page_title' => lang('import_adjustments'), 'bc' => $bc);
            $this->page_construct('adjustments/import', $this->data, $meta);

        }
    }
    
}
